/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.base.service.impl.popup.interceptor;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.service.impl.popup.AbstractPopUpWindowsInterceptor;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.base.service.impl.popup.interceptor.VersionExclusion;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

@PopUpProcess
public class VersionPopUpWindowsInterceptor
extends AbstractPopUpWindowsInterceptor {
    @Override
    protected void doInvoke(FilterPopUpWindowsBO popUpWindows) {
        List removeList = popUpWindows.getPopUpWindows().stream().filter(p -> {
            if (StringUtils.isBlank((CharSequence)p.getVersionJson()) || StringUtils.isBlank((CharSequence)popUpWindows.getParam().getCurVer())) {
                return false;
            }
            VersionExclusion versionExclusion = (VersionExclusion)JSON.parseObject((String)p.getVersionJson(), VersionExclusion.class);
            if (Objects.isNull(versionExclusion) || Objects.isNull(versionExclusion.getType())) {
                return false;
            }
            switch (versionExclusion.getType()) {
                case 1: {
                    if (StringUtils.isBlank((CharSequence)versionExclusion.getSpecifiedVersion())) {
                        return false;
                    }
                    return com.bxm.newidea.component.tools.StringUtils.compareVersion((String)popUpWindows.getParam().getCurVer(), (String)versionExclusion.getSpecifiedVersion()) > 0;
                }
                case 2: {
                    if (StringUtils.isBlank((CharSequence)versionExclusion.getSpecifiedVersion())) {
                        return false;
                    }
                    return com.bxm.newidea.component.tools.StringUtils.compareVersion((String)popUpWindows.getParam().getCurVer(), (String)versionExclusion.getSpecifiedVersion()) < 0;
                }
                case 3: {
                    if (CollectionUtils.isEmpty(versionExclusion.getContainVersions())) {
                        return false;
                    }
                    return !versionExclusion.getContainVersions().contains(popUpWindows.getParam().getCurVer());
                }
                case 4: {
                    if (CollectionUtils.isEmpty(versionExclusion.getContainVersions())) {
                        return false;
                    }
                    return versionExclusion.getContainVersions().contains(popUpWindows.getParam().getCurVer());
                }
            }
            return false;
        }).peek(p -> {
            if (this.log.isDebugEnabled()) {
                this.log.debug("\u7248\u672c\u8fc7\u6ee4\u5668, \u8fc7\u6ee4\u5f39\u7a97: {}, \u5f53\u524d\u7248\u672c: {}, \u914d\u7f6e\u7684\u7248\u672c\u4fe1\u606f: {}", new Object[]{p.getName(), popUpWindows.getParam().getCurVer(), p.getVersionJson()});
            }
        }).collect(Collectors.toList());
        popUpWindows.getPopUpWindows().removeAll(removeList);
    }
}

