/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.base.service.impl.popup.process.homepage;

import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import com.bxm.fossicker.constant.UserRedisKeyConstant;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.fossicker.user.facade.dto.UserInfoDto;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@PopUpProcess(special=PopUpEnum.HOME_NOVICE, order=PopUpProcessOrderEn.CUSTOM)
public class NovicePopUpWindowsProcess
extends AbstractPopUpWindowsProcess {
    @Autowired
    private UserInfoFacadeService userInfoFacadeService;

    @Override
    protected boolean preInvoke(FilterPopUpWindowsBO popUpWindows) {
        if (super.preInvoke(popUpWindows)) {
            if (com.bxm.newidea.component.tools.StringUtils.compareVersion((String)popUpWindows.getParam().getCurVer(), (String)"1.6.0") >= 0) {
                this.remove(popUpWindows, PopUpEnum.HOME_NOVICE);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {
        UserInfoDto userInfoDto = this.userInfoFacadeService.getUserById(popUpWindows.getParam().getUserId());
        String token = (String)this.redisHashMapAdapter.get(UserRedisKeyConstant.HASH_USER_TOKEN, Objects.toString(popUpWindows.getParam().getUserId()), String.class);
        if (StringUtils.isBlank((CharSequence)token) || Objects.isNull(userInfoDto) || Objects.isNull(userInfoDto.getId())) {
            this.autoClose(popUpWindows, Boolean.TRUE, 1);
            return;
        }
        if (!Objects.isNull(userInfoDto.getCharacter()) && Objects.equals(userInfoDto.getClaimedPacket(), Boolean.FALSE)) {
            return;
        }
        this.autoClose(popUpWindows, Boolean.TRUE, 0);
        this.remove(popUpWindows, PopUpEnum.HOME_NOVICE);
    }

    @Override
    protected void afterCompletion(FilterPopUpWindowsBO popUpWindows) {
        List commonPopUpWindowsEntryList = (List)popUpWindows.getParam("CURRENT_PROCESS_SUPPORT_POP_UP_KEY");
        if (!CollectionUtils.isEmpty((Collection)commonPopUpWindowsEntryList)) {
            commonPopUpWindowsEntryList.forEach(p -> p.setExt(p.getMaterialExt()));
        }
    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {
    }
}

