/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.base.service.impl.popup.process.homepage;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.facade.param.AppVersionParam;
import com.bxm.fossicker.base.facade.vo.AppChannelVersionVO;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.AppVersionService;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@PopUpProcess(special=PopUpEnum.HOME_VERSION, order=PopUpProcessOrderEn.CUSTOM)
public class VersionPopUpWindowsProcess
extends AbstractPopUpWindowsProcess {
    @Autowired
    private AppVersionService appVersionService;
    private static final String VERSION = "VERSION";

    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {
        AppVersionParam param = new AppVersionParam();
        BeanUtils.copyProperties((Object)popUpWindows.getParam(), (Object)param);
        AppChannelVersionVO appChannelVersionVO = this.appVersionService.getVersion(param);
        if (null != appChannelVersionVO) {
            popUpWindows.getParams().put(VERSION, appChannelVersionVO);
            return;
        }
        this.remove(popUpWindows, PopUpEnum.HOME_VERSION);
    }

    @Override
    protected void afterCompletion(FilterPopUpWindowsBO popUpWindows) {
        List commonPopUpWindowsEntryList = (List)popUpWindows.getParam("CURRENT_PROCESS_SUPPORT_POP_UP_KEY");
        if (!CollectionUtils.isEmpty((Collection)commonPopUpWindowsEntryList)) {
            commonPopUpWindowsEntryList.stream().forEach(p -> {
                AppChannelVersionVO appChannelVersionVO = (AppChannelVersionVO)popUpWindows.getParam(VERSION);
                if (Objects.isNull(appChannelVersionVO)) {
                    AppVersionParam param = new AppVersionParam();
                    BeanUtils.copyProperties((Object)popUpWindows.getParam(), (Object)param);
                    appChannelVersionVO = this.appVersionService.getVersion(param);
                }
                if (!Objects.isNull(appChannelVersionVO)) {
                    p.setExt(JSON.toJSONString((Object)appChannelVersionVO));
                }
            });
        }
    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {
        Long popId = this.getPopId(param);
        if (Objects.isNull(popId)) {
            this.log.warn("\u672a\u83b7\u53d6\u5230\u5f39\u7a97id\uff0c\u65e0\u6cd5\u8bb0\u5f55\u7248\u672c\u5347\u7ea7\u5f39\u7a97\u5f39\u51fa, type: {}, popIp: {}", (Object)param.getType(), (Object)param.getPopUpId());
            return;
        }
        this.closeAndIncrementTimes(popId, Objects.toString(param.getUserId()));
    }
}

