/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.base.service.impl.popup.process.homepage;

import com.bxm.fossicker.activity.constants.ActivityRedisKeyConstant;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@PopUpProcess(special=PopUpEnum.PAY_VIP_COST_CHARGE, order=PopUpProcessOrderEn.CUSTOM)
public class VipCostPopUpWindowsProcess
extends AbstractPopUpWindowsProcess {
    private final RedisHashMapAdapter redisHashMapAdapter;

    @Override
    protected boolean preInvoke(FilterPopUpWindowsBO popUpWindows) {
        KeyGenerator key = ActivityRedisKeyConstant.USER_EXIST_COST_LIST.copy();
        String isExistSeeCostDate = (String)this.redisHashMapAdapter.get(key, popUpWindows.getParam().getUserId().toString(), String.class);
        if (StringUtils.isNotBlank((CharSequence)isExistSeeCostDate)) {
            this.remove(popUpWindows, PopUpEnum.PAY_VIP_COST_CHARGE);
            return false;
        }
        return super.preInvoke(popUpWindows);
    }

    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {
    }

    @Override
    protected void afterCompletion(FilterPopUpWindowsBO popUpWindows) {
        List commonPopUpWindowsEntryList = (List)popUpWindows.getParam("CURRENT_PROCESS_SUPPORT_POP_UP_KEY");
        KeyGenerator key = ActivityRedisKeyConstant.USER_EXIST_COST_LIST.copy();
        String isExistSeeCostDate = (String)this.redisHashMapAdapter.get(key, popUpWindows.getParam().getUserId().toString(), String.class);
        commonPopUpWindowsEntryList.forEach(commonPopUpWindowsEntry -> commonPopUpWindowsEntry.setJumpUrl(commonPopUpWindowsEntry.getJumpUrl() + "&qt_detain=" + (com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)isExistSeeCostDate) ? 0 : 1)));
    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {
        Long popId = this.getPopId(param);
        if (Objects.isNull(popId)) {
            this.log.warn("\u672a\u83b7\u53d6\u5230\u5f39\u7a97id\uff0c\u65e0\u6cd5\u8bb0\u5f55\u9996\u9875\u767b\u5f55\u5f39\u7a97\u5f39\u51fa, type: {}, popIp: {}", (Object)param.getType(), (Object)param.getPopUpId());
            return;
        }
        this.closeAndIncrementTimes(popId, Objects.toString(param.getUserId()));
    }

    public VipCostPopUpWindowsProcess(RedisHashMapAdapter redisHashMapAdapter) {
        this.redisHashMapAdapter = redisHashMapAdapter;
    }
}

