/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.base.service.impl.popup.process.order;

import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import com.bxm.fossicker.constant.UserRedisKeyConstant;
import com.bxm.fossicker.order.facade.service.OrderFacadeService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@PopUpProcess(special=PopUpEnum.ORDER_FOLLOW_SUCCESS, order=PopUpProcessOrderEn.CUSTOM)
public class OrderFollowProcess
extends AbstractPopUpWindowsProcess {
    private static final Logger log = LoggerFactory.getLogger(OrderFollowProcess.class);
    @Autowired
    private RedisListAdapter redisListAdapter;
    @Autowired
    private OrderFacadeService orderFacadeService;
    private String EXT_KEY = "orderfollowsuccess";

    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {
        KeyGenerator keyGenerator = UserRedisKeyConstant.USER_HAS_NEW_FOLLOW_ORDER.copy().setKey(popUpWindows.getParam().getUserId() + "");
        List orderIds = this.redisListAdapter.range(keyGenerator, 0L, -1L, String.class);
        if (orderIds.size() > 0) {
            String info = this.orderFacadeService.getOrdersInfo(popUpWindows.getParam().getUserId(), orderIds);
            if (null != info) {
                popUpWindows.put(this.EXT_KEY, (Object)info);
                this.redisListAdapter.remove(keyGenerator);
            } else {
                this.remove(popUpWindows, PopUpEnum.ORDER_FOLLOW_SUCCESS);
            }
        } else {
            this.remove(popUpWindows, PopUpEnum.ORDER_FOLLOW_SUCCESS);
        }
    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {
    }

    @Override
    protected void afterCompletion(FilterPopUpWindowsBO popUpWindows) {
        String info = (String)popUpWindows.getParam(this.EXT_KEY);
        if (StringUtils.isNotEmpty((CharSequence)info)) {
            List commonPopUpWindowsEntryList = (List)popUpWindows.getParam("CURRENT_PROCESS_SUPPORT_POP_UP_KEY");
            JSONObject jsonObject = JSONObject.parseObject((String)info);
            if (!CollectionUtils.isEmpty((Collection)commonPopUpWindowsEntryList)) {
                commonPopUpWindowsEntryList.stream().forEach(p -> p.setExt(p.getMaterialExt().replace("{num}", jsonObject.getString("num")).replace("{totalAmount}", jsonObject.getString("totalAmount")).replace("{shareUserId}", popUpWindows.getParam().getUserId() + "")));
            }
        }
    }

    public static void main(String[] args) {
        String info = "{\"num\":1,\"totalAmount\":2}";
        JSONObject j = JSONObject.parseObject((String)info);
        System.out.println(j.getString("num"));
    }
}

