/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.base.service.impl.popup.process.task;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.activity.facade.TaskFacadeService;
import com.bxm.fossicker.activity.facade.model.DayGoldFacadeDto;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@PopUpProcess(special=PopUpEnum.TASK_NOVICE_SEVEN, order=PopUpProcessOrderEn.CUSTOM)
public class NoviceSevenWindowsProcess
extends AbstractPopUpWindowsProcess {
    @Autowired
    private UserInfoFacadeService userInfoFacadeService;
    @Autowired
    private TaskFacadeService taskFacadeService;
    public static final String DAY_GOLD_FACADE_DTO = "DAY_GOLD_FACADE_DTO";

    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {
        DayGoldFacadeDto dayGoldFacadeDto = this.taskFacadeService.dayGoldInfo(popUpWindows.getParam().getUserId());
        if (Objects.isNull(dayGoldFacadeDto)) {
            this.autoClose(popUpWindows, Boolean.TRUE, 0);
            this.remove(popUpWindows, PopUpEnum.TASK_NOVICE_SEVEN);
            return;
        }
        if (dayGoldFacadeDto.getUnObtain().booleanValue()) {
            popUpWindows.getParams().put(DAY_GOLD_FACADE_DTO, dayGoldFacadeDto);
            return;
        }
        this.autoClose(popUpWindows, Boolean.FALSE, 1);
        this.remove(popUpWindows, PopUpEnum.TASK_NOVICE_SEVEN);
    }

    @Override
    protected void afterCompletion(FilterPopUpWindowsBO popUpWindows) {
        List commonPopUpWindowsEntryList;
        DayGoldFacadeDto dayGoldFacadeDto = (DayGoldFacadeDto)popUpWindows.getParam(DAY_GOLD_FACADE_DTO);
        if (Objects.nonNull(dayGoldFacadeDto) && !CollectionUtils.isEmpty((Collection)(commonPopUpWindowsEntryList = (List)popUpWindows.getParam("CURRENT_PROCESS_SUPPORT_POP_UP_KEY")))) {
            commonPopUpWindowsEntryList.stream().forEach(p -> p.setExt(JSON.toJSONString((Object)dayGoldFacadeDto)));
        }
    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {
        Long popId = this.getPopId(param);
        if (Objects.isNull(popId)) {
            this.log.warn("\u672a\u83b7\u53d6\u5230\u5f39\u7a97id\uff0c\u65e0\u6cd5\u8bb0\u5f55\u65b0\u4eba\u4e03\u5929\u5f39\u7a97\u5f39\u51fa, type: {}, popIp: {}", (Object)param.getType(), (Object)param.getPopUpId());
            return;
        }
        this.closeAndIncrementTimes(popId, Objects.toString(param.getUserId()));
    }
}

