/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.base.service.impl.popup.process.task;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.activity.facade.SignFacadeService;
import com.bxm.fossicker.activity.facade.model.SignFacadeDto;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@PopUpProcess(special=PopUpEnum.TASK_SIGN, order=PopUpProcessOrderEn.CUSTOM)
public class SignPopUpWindowsProcess
extends AbstractPopUpWindowsProcess {
    @Autowired
    private SignFacadeService signFacadeService;

    @Override
    protected boolean preInvoke(FilterPopUpWindowsBO popUpWindows) {
        if (super.preInvoke(popUpWindows)) {
            if (Objects.equals(popUpWindows.getParam().getPosition().intValue(), 2) && StringUtils.compareVersion((String)popUpWindows.getParam().getCurVer(), (String)"1.3.0") >= 0) {
                this.remove(popUpWindows, PopUpEnum.TASK_SIGN);
                return false;
            }
            if (StringUtils.compareVersion((String)popUpWindows.getParam().getCurVer(), (String)"1.5.0") >= 0) {
                this.remove(popUpWindows, PopUpEnum.TASK_SIGN);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {
        Long userId = popUpWindows.getParam().getUserId();
        if (!this.signFacadeService.didSign(userId, new Date()).booleanValue()) {
            this.signFacadeService.signByDay(userId);
        } else {
            this.autoClose(popUpWindows, Boolean.FALSE, 1);
            this.remove(popUpWindows, PopUpEnum.TASK_SIGN);
        }
    }

    @Override
    protected void afterCompletion(FilterPopUpWindowsBO popUpWindows) {
        List commonPopUpWindowsEntryList = (List)popUpWindows.getParam("CURRENT_PROCESS_SUPPORT_POP_UP_KEY");
        if (!CollectionUtils.isEmpty((Collection)commonPopUpWindowsEntryList)) {
            commonPopUpWindowsEntryList.forEach(p -> {
                SignFacadeDto signInfo = this.signFacadeService.getSignInfo(popUpWindows.getParam().getUserId());
                if (!Objects.isNull(signInfo)) {
                    p.setExt(JSON.toJSONString((Object)signInfo));
                }
            });
        }
    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {
        Long popId = this.getPopId(param);
        if (Objects.isNull(popId)) {
            this.log.warn("\u672a\u83b7\u53d6\u5230\u5f39\u7a97id\uff0c\u65e0\u6cd5\u8bb0\u5f55\u7b7e\u5230\u5f39\u7a97\u5f39\u51fa, type: {}, popIp: {}", (Object)param.getType(), (Object)param.getPopUpId());
            return;
        }
        this.closeAndIncrementTimes(popId, Objects.toString(param.getUserId()));
    }
}

