/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.common.enums;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

public enum SecKillTimeEnum {
    SEC_KILL_10(10, 0, 0, 12, 0, 0, "10\u70b9\u6863"),
    SEC_KILL_12(12, 0, 0, 15, 0, 0, "12\u70b9\u6863"),
    SEC_KILL_15(15, 0, 0, 20, 0, 0, "15\u70b9\u6863"),
    SEC_KILL_20(20, 0, 0, 22, 0, 0, "20\u70b9\u6863"),
    SEC_KILL_22(22, 0, 0, 10, 0, 0, "22\u70b9\u6863");

    private int startTimeHour;
    private int startTimeMin;
    private int startTimeSec;
    private int endTimeHour;
    private int endTimeMin;
    private int endTimeSec;
    private String description;
    private SecKillTimeEnum preEnum;
    private SecKillTimeEnum nextEnum;

    public int getStartTimeHour() {
        return this.startTimeHour;
    }

    public void setStartTimeHour(int startTimeHour) {
        this.startTimeHour = startTimeHour;
    }

    public int getStartTimeMin() {
        return this.startTimeMin;
    }

    public void setStartTimeMin(int startTimeMin) {
        this.startTimeMin = startTimeMin;
    }

    public int getStartTimeSec() {
        return this.startTimeSec;
    }

    public void setStartTimeSec(int startTimeSec) {
        this.startTimeSec = startTimeSec;
    }

    public int getEndTimeHour() {
        return this.endTimeHour;
    }

    public void setEndTimeHour(int endTimeHour) {
        this.endTimeHour = endTimeHour;
    }

    public int getEndTimeMin() {
        return this.endTimeMin;
    }

    public void setEndTimeMin(int endTimeMin) {
        this.endTimeMin = endTimeMin;
    }

    public int getEndTimeSec() {
        return this.endTimeSec;
    }

    public void setEndTimeSec(int endTimeSec) {
        this.endTimeSec = endTimeSec;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SecKillTimeEnum getPreEnum() {
        return this.preEnum;
    }

    public void setPreEnum(SecKillTimeEnum preEnum) {
        this.preEnum = preEnum;
    }

    public SecKillTimeEnum getNextEnum() {
        return this.nextEnum;
    }

    public void setNextEnum(SecKillTimeEnum nextEnum) {
        this.nextEnum = nextEnum;
    }

    private SecKillTimeEnum(int startTimeHour, int startTimeMin, int startTimeSec, int endTimeHour, int endTimeMin, int endTimeSec, String description) {
        this.startTimeHour = startTimeHour;
        this.startTimeMin = startTimeMin;
        this.startTimeSec = startTimeSec;
        this.endTimeHour = endTimeHour;
        this.endTimeMin = endTimeMin;
        this.endTimeSec = endTimeSec;
        this.description = description;
    }

    public static void buildEnumRelation() {
        SEC_KILL_10.setPreEnum(SEC_KILL_22);
        SEC_KILL_10.setNextEnum(SEC_KILL_12);
        SEC_KILL_12.setPreEnum(SEC_KILL_10);
        SEC_KILL_12.setNextEnum(SEC_KILL_15);
        SEC_KILL_15.setPreEnum(SEC_KILL_12);
        SEC_KILL_15.setNextEnum(SEC_KILL_20);
        SEC_KILL_20.setPreEnum(SEC_KILL_15);
        SEC_KILL_20.setNextEnum(SEC_KILL_22);
        SEC_KILL_22.setPreEnum(SEC_KILL_20);
        SEC_KILL_22.setNextEnum(SEC_KILL_10);
    }

    public static SecKillTimeEnum isWhichInTime(LocalTime nowTime) {
        for (SecKillTimeEnum secKillTimeEnum : SecKillTimeEnum.values()) {
            LocalTime startTime = LocalTime.of(secKillTimeEnum.getStartTimeHour(), secKillTimeEnum.getStartTimeMin(), secKillTimeEnum.getStartTimeSec());
            LocalTime endTime = LocalTime.of(secKillTimeEnum.getEndTimeHour(), secKillTimeEnum.getEndTimeMin(), secKillTimeEnum.getEndTimeSec());
            if (nowTime.equals(startTime)) {
                return secKillTimeEnum;
            }
            if (!nowTime.isAfter(startTime) || !nowTime.isBefore(endTime)) continue;
            return secKillTimeEnum;
        }
        return SEC_KILL_22;
    }

    public static LocalDateTime getDateStartTimeByEnum(LocalDate localDate, SecKillTimeEnum secKillTimeEnum) {
        return localDate.atTime(secKillTimeEnum.getStartTimeHour(), secKillTimeEnum.getStartTimeMin(), secKillTimeEnum.getStartTimeSec());
    }

    public static LocalDateTime getDateEndTimeByEnum(LocalDate localDate, SecKillTimeEnum secKillTimeEnum) {
        return localDate.atTime(secKillTimeEnum.getEndTimeHour(), secKillTimeEnum.getEndTimeMin(), secKillTimeEnum.getEndTimeSec());
    }
}

