/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.common.utils;

import com.bxm.fossicker.commodity.common.dto.CommissionAndCoupon;
import com.bxm.fossicker.commodity.common.dto.CommodityCommissionAndCoupon;
import com.bxm.fossicker.commodity.common.dto.PlatformCommissionRateInfo;
import com.bxm.fossicker.commodity.common.utils.CommodityNumberUtils;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;

public class CommodityCalUtils {
    private static Pattern COUPON_PRICE_PATTERN = Pattern.compile("\u51cf(.*?)\u5143");

    public static Double calCommission(CommodityCommissionAndCoupon commodityCommissionAndCoupon, Double reservePrice) {
        Double commissionRegularPrice = commodityCommissionAndCoupon.getCommissionRegularPrice();
        if (!CommodityNumberUtils.isNullOrZero(commissionRegularPrice)) {
            return commissionRegularPrice;
        }
        String commissionRateByThird = ObjectUtils.toString((Object)commodityCommissionAndCoupon.getCommissionRateByThird(), (String)"0");
        BigDecimal commissionRateByThirdDecimal = new BigDecimal(commissionRateByThird);
        BigDecimal commissionRateDecimal = new BigDecimal(commodityCommissionAndCoupon.getCommissionRate().toString());
        BigDecimal couponPriceDecimal = new BigDecimal(commodityCommissionAndCoupon.getCouponPrice().toString());
        BigDecimal reservePriceDecimal = new BigDecimal(reservePrice.toString());
        BigDecimal commissionPrice = reservePriceDecimal.subtract(couponPriceDecimal).multiply(commissionRateByThirdDecimal).multiply(commissionRateDecimal).setScale(2, 1);
        return commissionPrice.doubleValue();
    }

    public static Double calPlatformCommission(CommissionAndCoupon commissionAndCoupon, Double reservePrice) {
        String commissionRateByThird = ObjectUtils.toString((Object)commissionAndCoupon.getCommissionRateByThird(), (String)"0");
        BigDecimal commissionRateByThirdDecimal = new BigDecimal(commissionRateByThird);
        BigDecimal couponPriceDecimal = new BigDecimal(commissionAndCoupon.getCouponPrice().toString());
        BigDecimal reservePriceDecimal = new BigDecimal(reservePrice.toString());
        return CommodityCalUtils.calPlatformCommission(commissionRateByThirdDecimal, couponPriceDecimal, reservePriceDecimal);
    }

    public static Double calPlatformCommission(BigDecimal commissionRateByThird, BigDecimal couponPriceDecimal, BigDecimal reservePriceDecimal) {
        BigDecimal commissionPrice = reservePriceDecimal.subtract(couponPriceDecimal).multiply(commissionRateByThird).setScale(2, 1);
        return commissionPrice.doubleValue();
    }

    public static Double calCommissionWithVip(CommodityCommissionAndCoupon commodityCommissionAndCoupon, Double reservePrice, boolean vipFlag) {
        String commissionRateByThird = ObjectUtils.toString((Object)commodityCommissionAndCoupon.getCommissionRateByThird(), (String)"0");
        BigDecimal commissionRateByThirdDecimal = new BigDecimal(commissionRateByThird);
        BigDecimal commissionRateDecimal = new BigDecimal(Objects.toString(commodityCommissionAndCoupon.getCommissionRate(), "0"));
        BigDecimal couponPriceDecimal = new BigDecimal(commodityCommissionAndCoupon.getCouponPrice().toString());
        BigDecimal reservePriceDecimal = new BigDecimal(reservePrice.toString());
        BigDecimal vipCommissionRate = new BigDecimal(commodityCommissionAndCoupon.getVipCommissionRate().toString());
        if (!commodityCommissionAndCoupon.isSpecialCommissionFlag() && vipFlag) {
            return reservePriceDecimal.subtract(couponPriceDecimal).multiply(commissionRateByThirdDecimal).multiply(vipCommissionRate).setScale(2, 1).doubleValue();
        }
        Double commissionRegularPrice = commodityCommissionAndCoupon.getCommissionRegularPrice();
        if (!CommodityNumberUtils.isNullOrZero(commissionRegularPrice)) {
            return commissionRegularPrice;
        }
        return reservePriceDecimal.subtract(couponPriceDecimal).multiply(commissionRateByThirdDecimal).multiply(commissionRateDecimal).setScale(2, 1).doubleValue();
    }

    public static Double calCommissionForPlatformCommission(CommodityCommissionAndCoupon platformCommissionDTO, Double platformCommission) {
        return CommodityCalUtils.calCommissionForPlatformCommission(platformCommissionDTO.getCommissionRegularPrice(), platformCommission, platformCommissionDTO.getCommissionRate());
    }

    public static Double calCommissionForPlatformCommission(PlatformCommissionRateInfo platformCommissionRateInfo, Double platformCommission) {
        return CommodityCalUtils.calCommissionForPlatformCommission(platformCommissionRateInfo.getCommissionRegularPrice(), platformCommission, platformCommissionRateInfo.getCommissionRate());
    }

    public static Double calCommissionForPlatformCommission(Double commissionRegularPrice, Double platformCommission, Double commissionRate) {
        if (!CommodityNumberUtils.isNullOrZero(commissionRegularPrice)) {
            return commissionRegularPrice;
        }
        BigDecimal platformCommissionD = CommodityCalUtils.convert(platformCommission);
        BigDecimal commissionRateD = CommodityCalUtils.convert(commissionRate);
        BigDecimal commissionPrice = platformCommissionD.multiply(commissionRateD).setScale(2, 1);
        return commissionPrice.doubleValue();
    }

    public static Double calCommissionForPlatformCommissionWithVip(PlatformCommissionRateInfo platformCommissionRateInfo, Double platformCommission, boolean vipFlag) {
        if (Objects.isNull(platformCommission)) {
            platformCommission = 0.0;
        }
        if (!platformCommissionRateInfo.isSpecialCommissionFlag() && vipFlag) {
            BigDecimal platformCommissionD = CommodityCalUtils.convert(platformCommission);
            Double vipCommissionRate = platformCommissionRateInfo.getVipCommissionRate();
            BigDecimal vipCommissionRateD = CommodityCalUtils.convert(vipCommissionRate);
            BigDecimal commissionPriceResult = platformCommissionD.multiply(vipCommissionRateD).setScale(2, 1);
            return commissionPriceResult.doubleValue();
        }
        Double regularCommissionPrice = platformCommissionRateInfo.getCommissionRegularPrice();
        Double commissionRate = platformCommissionRateInfo.getCommissionRate();
        if (!CommodityNumberUtils.isNullOrZero(regularCommissionPrice)) {
            return regularCommissionPrice;
        }
        BigDecimal platformCommissionD = CommodityCalUtils.convert(platformCommission);
        BigDecimal commissionRateD = CommodityCalUtils.convert(commissionRate);
        BigDecimal commissionPriceResult = platformCommissionD.multiply(commissionRateD).setScale(2, 1);
        return commissionPriceResult.doubleValue();
    }

    public static Double calCommissionForPlatformCommissionWithVip(CommodityCommissionAndCoupon platformCommissionDTO, Double platformCommission, boolean vipFlag) {
        PlatformCommissionRateInfo platformCommissionRateInfo = new PlatformCommissionRateInfo();
        BeanUtils.copyProperties((Object)platformCommissionDTO, (Object)platformCommissionRateInfo);
        return CommodityCalUtils.calCommissionForPlatformCommissionWithVip(platformCommissionRateInfo, platformCommission, vipFlag);
    }

    public static Double calCommissionForDiscountPrice(CommodityCommissionAndCoupon platformCommissionDTO, Double discountPrice) {
        Double commissionRegularPrice = platformCommissionDTO.getCommissionRegularPrice();
        if (!CommodityNumberUtils.isNullOrZero(commissionRegularPrice)) {
            return commissionRegularPrice;
        }
        BigDecimal discountPriceD = CommodityCalUtils.convert(discountPrice);
        BigDecimal commissionRateByThird = new BigDecimal(platformCommissionDTO.getCommissionRateByThird());
        BigDecimal commissionRateDecimal = new BigDecimal(platformCommissionDTO.getCommissionRate().toString());
        BigDecimal commissionPrice = discountPriceD.multiply(commissionRateByThird).multiply(commissionRateDecimal).setScale(2, 1);
        return commissionPrice.doubleValue();
    }

    public static Double calCommodityPriceWithSubtractingCoupon(Double commodityPrice, Double couponPrice) {
        BigDecimal couponPriceDecimal = CommodityCalUtils.convert(couponPrice);
        BigDecimal commodityPriceDecimal = CommodityCalUtils.convert(commodityPrice);
        BigDecimal commodityFinalPrice = commodityPriceDecimal.subtract(couponPriceDecimal).setScale(2, 1);
        return commodityFinalPrice.doubleValue();
    }

    public static Double calPriceWithSubtractingCouponAndCommission(Double commodityPrice, Double couponPrice, Double commissionPrice) {
        BigDecimal couponPriceDecimal = new BigDecimal(null == couponPrice ? "0" : couponPrice.toString());
        BigDecimal commodityPriceDecimal = CommodityCalUtils.convert(commodityPrice);
        BigDecimal commissionPriceDecimal = CommodityCalUtils.convert(commissionPrice);
        BigDecimal commodityFinalPrice = commodityPriceDecimal.subtract(couponPriceDecimal).subtract(commissionPriceDecimal).setScale(2, 1);
        return commodityFinalPrice.doubleValue();
    }

    public static Double calPriceWithSubtractingCouponAndCommission(Double discountPrice, Double commissionPrice) {
        BigDecimal discountPriceD = CommodityCalUtils.convert(discountPrice);
        BigDecimal commissionPriceDecimal = CommodityCalUtils.convert(commissionPrice);
        BigDecimal commodityFinalPrice = discountPriceD.subtract(commissionPriceDecimal).setScale(2, 1);
        return commodityFinalPrice.doubleValue();
    }

    public static Double calVipCommission(Double platformCommission, Double vipCommissionRate) {
        BigDecimal vipCommission = CommodityCalUtils.convert(platformCommission).multiply(CommodityCalUtils.convert(vipCommissionRate)).setScale(2, 1);
        return vipCommission.doubleValue();
    }

    public static Double calVipCommission(Double platformCommission, Double vipCommissionRate, boolean vipFlag, boolean specialCommission, Double commissionPrice) {
        if (vipFlag && specialCommission) {
            return commissionPrice;
        }
        BigDecimal vipCommission = CommodityCalUtils.convert(platformCommission).multiply(CommodityCalUtils.convert(vipCommissionRate)).setScale(2, 1);
        return vipCommission.doubleValue();
    }

    public static Double calVipCommission(Double discountPrice, Double thirdPartyCommissionRate, Double vipCommissionRate) {
        BigDecimal vipCommission = CommodityCalUtils.convert(discountPrice).multiply(CommodityCalUtils.convert(thirdPartyCommissionRate)).multiply(CommodityCalUtils.convert(vipCommissionRate)).setScale(2, 1);
        return vipCommission.doubleValue();
    }

    public static Double calFavourablePrice(Double commissionPrice, Double couponPrice) {
        if (commissionPrice == null) {
            commissionPrice = 0.0;
        }
        if (couponPrice == null) {
            couponPrice = 0.0;
        }
        BigDecimal vipCommission = CommodityCalUtils.convert(commissionPrice).add(CommodityCalUtils.convert(couponPrice)).setScale(2, 1);
        return vipCommission.doubleValue();
    }

    private static BigDecimal convert(Double source) {
        if (null == source) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(source);
    }

    public static Double calDiscountPrice(Double reservePrice, Double couponPrice) {
        if (CommodityNumberUtils.isNullOrZero(reservePrice)) {
            return 0.0;
        }
        if (CommodityNumberUtils.isNullOrZero(couponPrice)) {
            return new BigDecimal(reservePrice.toString()).setScale(2, 1).doubleValue();
        }
        return new BigDecimal(reservePrice.toString()).subtract(new BigDecimal(couponPrice.toString())).setScale(2, 1).doubleValue();
    }

    public static Double calExtraCommissionPrice(Double commonCommissionPrice, Double vipCommissionPrice) {
        if (CommodityNumberUtils.isNullOrZero(commonCommissionPrice) || CommodityNumberUtils.isNullOrZero(vipCommissionPrice)) {
            return 0.0;
        }
        return new BigDecimal(Objects.toString(vipCommissionPrice)).subtract(new BigDecimal(Objects.toString(commonCommissionPrice))).setScale(2, 1).doubleValue();
    }

    public static Double getCouponPriceByRegex(String couponInfo) {
        String couponPrice;
        if (StringUtils.isBlank((String)couponInfo)) {
            return 0.0;
        }
        Matcher matcher = COUPON_PRICE_PATTERN.matcher(couponInfo);
        if (matcher.find() && com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)(couponPrice = matcher.group(1)))) {
            return Double.valueOf(couponPrice);
        }
        return 0.0;
    }
}

