package com.bxm.fossicker.commodity.common.constants;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;

/**
 * REDIS 配置类
 *
 * @author donghy
 */
public class CommodityRedisKeyConstants {

    /**
     * base
     */
    public static KeyGenerator BASE_KEY = DefaultKeyGenerator.build().setModule("commodity");

    /**
     * 按照关键词搜索商品列表
     */
    public static KeyGenerator COMMODITY_QUERY_BY_NAME = DefaultKeyGenerator.build("commodity", "search");

    /**
     * 超级入口分类key
     */
    public static KeyGenerator COMMODITY_SUPER_GOODS_LIST = DefaultKeyGenerator.build("commodity", "init", "super_goods_label");

    /**
     * 商品分类key
     */
    public static KeyGenerator COMMDITY_GOODS_LABEL_CONTANS = DefaultKeyGenerator.build("commodity", "goods", "label");

    /**
     * 限时秒杀产品首页展示-聚划算
     */
    public static KeyGenerator COMMODITY_SEC_KILL_INDEX_JU = DefaultKeyGenerator.build("commodity", "secKill_index", "ju");

    /**
     * 限时秒杀产品首页展示-淘抢购
     */
    public static KeyGenerator COMMODITY_SEC_KILL_INDEX_TAO = DefaultKeyGenerator.build("commodity", "secKill_index", "tao");

    /**
     * 商品佣金通用规则-自购
     */
    public static KeyGenerator COMMODITY_COMMISSION_COMMON_PURCHASE = DefaultKeyGenerator.build("commodity", "common_commission", "PURCHASE");


    /**
     * 商品佣金通用规则-上级
     */
    public static KeyGenerator COMMODITY_COMMISSION_COMMON_PARENT = DefaultKeyGenerator.build("commodity", "common_commission", "parent");


    /**
     * 商品佣金通用规则-上上级
     */
    public static KeyGenerator COMMODITY_COMMISSION_COMMON_GRANDPARENT = DefaultKeyGenerator.build("commodity", "common_commission", "grand_parent");

    /**
     * 限时秒杀产品-淘抢购
     */
    public static KeyGenerator COMMODITY_SEC_KILL_TAO = DefaultKeyGenerator.build("commodity", "secKill", "tao");

    /**
     * 限时秒杀产品-淘抢购
     */
    public static KeyGenerator COMMODITY_SEC_KILL_JU = DefaultKeyGenerator.build("commodity", "secKill", "ju");

    /**
     * 分类 类目ID KEY
     */
    public static KeyGenerator COMMODITY_GOODS_LIST_SEARCH_KEY = DefaultKeyGenerator.build("commodity", "goods",
            "search");

    /**
     * 精选   第三方接口数据缓存
     */
    public static KeyGenerator COMMODITY_GOODS_LIST_WELLCHOSE_KEY = DefaultKeyGenerator.build("commodity", "goods",
            "wellchose");

    /**
     * 精选 商品池新人新人专享商品缓存
     */
    public static KeyGenerator COMMODITY_GOODS_LIST_WELLCHOSE_POOL_KEY = DefaultKeyGenerator.build("commodity", "goods",
            "wellchosePool");

    /**
     * 商品池扩展缓存
     */
    public static KeyGenerator COMMODITY_GOODS_LIST_EXTEND = DefaultKeyGenerator.build("commodity", "goods",
            "extend");

    /**
     * 商品池扩展缓存
     */
    public static KeyGenerator COMMODITY_GOODS_LIST_ZERO = DefaultKeyGenerator.build("commodity", "goods",
            "zero");

    /**
     * 精选  商品池置顶商品缓存
     */
    public static KeyGenerator COMMODITY_GOODS_LIST_WELLCHOSE_POOL_TOP_KEY = DefaultKeyGenerator.build("commodity",
            "goods", "wellchosePoolTop");


    /**
     * 商品详情
     */
    public static KeyGenerator COMMODITY_DETAIL = DefaultKeyGenerator.build("commodity", "detail");

    /**
     * 推荐商品
     */
    public static KeyGenerator COMMODITY_RECOMMEND = DefaultKeyGenerator.build("commodity", "recommend");

    /**
     * 商品提醒
     */
    public static KeyGenerator COMMODITY_REMIND = DefaultKeyGenerator.build("commodity", "sec", "remind");

    /**
     * 商品从第三方获取到的佣金
     */
    public static KeyGenerator COMMODITY_COMMISSION = DefaultKeyGenerator.build("commodity", "commission");

    /**
     * 平台配置的特殊商品佣金
     */
    public static KeyGenerator COMMODITY_PLATFORM_COMMISSION = DefaultKeyGenerator.build("commodity", "platform_commission");

    /**
     * 商品浏览记录
     */
    public static KeyGenerator COMMODITY_BROWSE_RECORD = DefaultKeyGenerator.build("commodity", "browse", "record");

    /**
     * 商品从第三方获取到的佣金
     */
    public static KeyGenerator COMMODITY_PRICE = DefaultKeyGenerator.build("commodity", "price");

    /**
     * 商品浏览记录
     */
    public static KeyGenerator COMMODITY_BROWSE_GOLD_LIMIT = DefaultKeyGenerator.build("commodity", "gold", "limit");

    /**
     * 广告卷商品信息缓存
     */
    public static KeyGenerator COMMODITY_TICKET_GOODS_INFO = DefaultKeyGenerator.build("commodity", "ticket", "info");

    /**
     * 广告部的广告位和pid映射
     */
    public static KeyGenerator COMMODITY_ADVERT_PID_MAP = DefaultKeyGenerator.build("commodity", "advert", "pidMap");

    /**
     * pid和广告部bxmId的缓存
     */
    public static KeyGenerator COMMODITY_ADVERT_PID_BXMID_MAP = DefaultKeyGenerator.build("commodity", "advert", "bxmIdMap");

    /**
     * 推送订单到广告部到缓存
     */
    public static KeyGenerator COMMODITY_SEND_ADVERT = DefaultKeyGenerator.build("commodity", "advert", "order");

    public static KeyGenerator COMMODITY_GOODS_SEARCH_SUBCID = COMMODITY_QUERY_BY_NAME.copy().setKey("subcid");

    /**
     * 新人专享商品set
     */
    public static KeyGenerator COMMODITY_NEWBIE_SET = DefaultKeyGenerator.build("commodity", "newbie", "set");

    /**
     * vip 0元购商品set
     */
    public static KeyGenerator COMMODITY_VIP_ZERO_SET = DefaultKeyGenerator.build("commodity", "vipZero", "set");

    /**
     * 每一个用户的每日浏览历史记录
     */
    public static KeyGenerator BROWSE_HISTORY_SET = DefaultKeyGenerator.build("commodity", "cache", "browse");


    /**
     * 非高佣商品的优惠券缓存key
     */
    public static KeyGenerator OTHER_COMMODITY_COUPON_INFO = BASE_KEY.copy().setGroup("cache").setKey("otherCommodityCouponInfo");


}
