package com.bxm.fossicker.commodity.common.dto;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

/**
 * 查询三方接口获取到的佣金和优惠券信息
 * 不包含自身平台的佣金信息
 * @Author: Gonzo
 * @date  2020-03-02 14:00
 * @since 1.6.0
 */
@Data
@Builder
public class CommissionAndCoupon {

    /**
     * 淘宝商品id
     */
    private Long goodsId;

    /**
     * 第三方佣金比例
     */
    private Double commissionRateByThird;

    /**
     * 优惠券面额
     */
    private Double couponPrice;

    /**
     * 优惠券领取url
     */
    private String couponUrl;

    @Tolerate
    public CommissionAndCoupon() {

    }
}
