package com.bxm.fossicker.commodity.common.dto;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

/**
 * 商品佣金以及优惠券信息DTO
 * @author donghy
 */
@Builder
@Data
public class CommodityCommissionAndCoupon {

    @Tolerate
    public CommodityCommissionAndCoupon() {
    }

    /**
     * 淘宝商品id
     */
    private Long goodsId;

    /**
     * 趣淘金自身平台佣金比例
     */
    private Double commissionRate;

    /**
     * 趣淘金自身平台固定佣金金额
     */
    private Double commissionRegularPrice;

    /**
     * 第三方佣金比例
     */
    private Double commissionRateByThird;

    /**
     * 优惠券面额
     */
    private Double couponPrice;

    /**
     * 优惠券领取url
     */
    private String couponUrl;

    /**
     * vip佣金比例
     */
    private Double vipCommissionRate;

    /**
     * 特殊返佣标志  true:是特殊返佣  false:普通返佣
     */
    private boolean specialCommissionFlag;

}



