package com.bxm.fossicker.commodity.common.dto;

import lombok.Data;

/**
 * 自身平台的佣金比例信息
 * 不包含优惠券金额、链接、佣金比例等数据
 * @Author: Gonzo
 * @date  2020-03-02 14:36
 * @since 1.6.0
 */
@Data
public class PlatformCommissionRateInfo {

    /**
     * 淘宝商品id
     */
    private Long goodsId;

    /**
     * 趣淘金自身平台佣金比例
     */
    private Double commissionRate;

    /**
     * 趣淘金自身平台固定佣金金额
     */
    private Double commissionRegularPrice;

    /**
     * vip佣金比例
     */
    private Double vipCommissionRate;

    /**
     * 特殊返佣标志  true:是特殊返佣  false:普通返佣
     */
    private boolean specialCommissionFlag;

}
