package com.bxm.fossicker.commodity.common.enums;

/**
 * 商品收藏状态枚举
 * @author donghy
 */
public enum CommodityFavoriteStatusEnum {

    /**
     * 已收藏
     */
    FAVORITE_STATUS(1, "已收藏"),

    /**
     * 未收藏
     */
    NOT_FAVORITE_STATUS(0, "未收藏");

    CommodityFavoriteStatusEnum(Integer status, String description) {
        this.status = status;
        this.description = description;
    }

    /**
     * 收藏状态 1-已收藏,0-未收藏
     */
    private Integer status;

    /**
     * 状态描述
     */
    private String description;

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
