package com.bxm.fossicker.commodity.common.enums;

import com.bxm.newidea.component.tools.StringUtils;

/**
 * 商品排序类型美剧
 * @author donghy
 */
public enum CommoditySortTypeEnum {

    /**
     * 综合排序-累计推广量降序
     */
    GENERAL("0", "tk_total_sales_des"),

    /**
     * 1-销量降序
     */
    TOTAL_SALES_DES("1", "total_sales_des"),

    /**
     * 2-佣金比降序
     */
    TK_RATE_DES("2", "tk_rate_des");

    CommoditySortTypeEnum(String code, String sortType) {
        this.code = code;
        this.sortType = sortType;
    }

    /**
     * 分类码
     */
    private String code;

    /**
     * 分类类型-分类规则
     */
    private String sortType;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getSortType() {
        return sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    /**
     * 根据code获取排序类型-排序规则
     * @param code 排序code
     * @return 排序类型-排序规则
     */
    public static String getTypeByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        for (CommoditySortTypeEnum enums : CommoditySortTypeEnum.values()) {
            if (code.equals(enums.getCode())) {
                return enums.getSortType();
            }
        }

        return null;
    }
}
