package com.bxm.fossicker.commodity.common.enums;

/**
 * 库内商品状态
 */
public enum LocalCommodityStatusEnum {

    /**
     * 上架状态
     */
    Valid((byte) 1, "上架"),
    /**
     * 下架状态
     */
    InValid((byte) 0, "下架");

    /**
     * 上下架状态
     */
    private byte status;

    /**
     * 描述
     */
    private String description;

    LocalCommodityStatusEnum(byte status, String description) {
        this.status = status;
        this.description = description;
    }

    public byte getStatus() {
        return status;
    }

    public void setStatus(byte status) {
        this.status = status;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
