package com.bxm.fossicker.commodity.common.enums;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

public enum SecKillTimeEnum {
    /**
     * 秒杀10点档
     */
    SEC_KILL_10(10, 0, 0, 12, 0, 0, "10点档"),
    /**
     * 秒杀12点档
     */
    SEC_KILL_12(12, 0, 0, 15, 0, 0, "12点档"),
    /**
     * 秒杀15点档
     */
    SEC_KILL_15(15, 0, 0, 20, 0, 0, "15点档"),
    /**
     * 秒杀20点档
     */
    SEC_KILL_20(20, 0, 0, 22, 0, 0, "20点档"),
    /**
     * 秒杀22点档
     */
    SEC_KILL_22(22, 0, 0, 10, 0, 0, "22点档");

    /**
     * 开始时间/小时
     */
    private int startTimeHour;

    /**
     * 开始时间/分
     */
    private int startTimeMin;

    /**
     * 开始时间/秒
     */
    private int startTimeSec;

    /**
     * 结束时间/小时
     */
    private int endTimeHour;

    /**
     * 结束时间/分
     */
    private int endTimeMin;

    /**
     * 结束时间/秒
     */
    private int endTimeSec;

    /**
     * 描述
     */
    private String description;

    /**
     * 上一个枚举
     */
    private SecKillTimeEnum preEnum;

    /**
     * 下一个枚举
     */
    private SecKillTimeEnum nextEnum;


    public int getStartTimeHour() {
        return startTimeHour;
    }

    public void setStartTimeHour(int startTimeHour) {
        this.startTimeHour = startTimeHour;
    }

    public int getStartTimeMin() {
        return startTimeMin;
    }

    public void setStartTimeMin(int startTimeMin) {
        this.startTimeMin = startTimeMin;
    }

    public int getStartTimeSec() {
        return startTimeSec;
    }

    public void setStartTimeSec(int startTimeSec) {
        this.startTimeSec = startTimeSec;
    }

    public int getEndTimeHour() {
        return endTimeHour;
    }

    public void setEndTimeHour(int endTimeHour) {
        this.endTimeHour = endTimeHour;
    }

    public int getEndTimeMin() {
        return endTimeMin;
    }

    public void setEndTimeMin(int endTimeMin) {
        this.endTimeMin = endTimeMin;
    }

    public int getEndTimeSec() {
        return endTimeSec;
    }

    public void setEndTimeSec(int endTimeSec) {
        this.endTimeSec = endTimeSec;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SecKillTimeEnum getPreEnum() {
        return preEnum;
    }

    public void setPreEnum(SecKillTimeEnum preEnum) {
        this.preEnum = preEnum;
    }

    public SecKillTimeEnum getNextEnum() {
        return nextEnum;
    }

    public void setNextEnum(SecKillTimeEnum nextEnum) {
        this.nextEnum = nextEnum;
    }

    SecKillTimeEnum(int startTimeHour, int startTimeMin, int startTimeSec, int endTimeHour, int endTimeMin, int endTimeSec, String description) {
        this.startTimeHour = startTimeHour;
        this.startTimeMin = startTimeMin;
        this.startTimeSec = startTimeSec;
        this.endTimeHour = endTimeHour;
        this.endTimeMin = endTimeMin;
        this.endTimeSec = endTimeSec;
        this.description = description;
    }

    /**
     * 简历枚举关系类
     */
    public static void buildEnumRelation(){
        SEC_KILL_10.setPreEnum(SEC_KILL_22);
        SEC_KILL_10.setNextEnum(SEC_KILL_12);

        SEC_KILL_12.setPreEnum(SEC_KILL_10);
        SEC_KILL_12.setNextEnum(SEC_KILL_15);

        SEC_KILL_15.setPreEnum(SEC_KILL_12);
        SEC_KILL_15.setNextEnum(SEC_KILL_20);

        SEC_KILL_20.setPreEnum(SEC_KILL_15);
        SEC_KILL_20.setNextEnum(SEC_KILL_22);

        SEC_KILL_22.setPreEnum(SEC_KILL_20);
        SEC_KILL_22.setNextEnum(SEC_KILL_10);

    }

    /**
     * 判断传入的时间在哪个时间范围
     *
     * @param nowTime 当前时间
     * @return 返回所在时间档的枚举
     */
    public static SecKillTimeEnum isWhichInTime(LocalTime nowTime) {

        for (SecKillTimeEnum secKillTimeEnum : SecKillTimeEnum.values()) {

            //获取开始结束时间的localTime值
            LocalTime startTime = LocalTime.of(secKillTimeEnum.getStartTimeHour(), secKillTimeEnum.getStartTimeMin()
                    , secKillTimeEnum.getStartTimeSec());
            LocalTime endTime = LocalTime.of(secKillTimeEnum.getEndTimeHour(), secKillTimeEnum.getEndTimeMin()
                    , secKillTimeEnum.getEndTimeSec());

            //若正好在整点时间
            if (nowTime.equals(startTime)) {
                return secKillTimeEnum;
            }

            //判断在哪个时间范围内
            if (nowTime.isAfter(startTime) && nowTime.isBefore(endTime)) {
                return secKillTimeEnum;
            }
        }
        //22点场为跨时段场,并且作为默认时间段
        return SEC_KILL_22;
    }

    public static LocalDateTime getDateStartTimeByEnum(LocalDate localDate, SecKillTimeEnum secKillTimeEnum) {
        return localDate.atTime(secKillTimeEnum.getStartTimeHour(), secKillTimeEnum.getStartTimeMin(), secKillTimeEnum.getStartTimeSec());
    }

    public static LocalDateTime getDateEndTimeByEnum(LocalDate localDate, SecKillTimeEnum secKillTimeEnum) {
        return localDate.atTime(secKillTimeEnum.getEndTimeHour(), secKillTimeEnum.getEndTimeMin(), secKillTimeEnum.getEndTimeSec());
    }


}
