package com.bxm.fossicker.commodity.common.enums;

public enum ShopTypeEnum {

    /**
     * 淘宝
     */
    TAOBAO(0, "C"),

    /**
     * 天猫
     */
    TMALL(1, "B"),

    /**
     * 默认类型-为淘宝
     */
    DEFAULT(0, "C");

    ShopTypeEnum(Integer type, String description) {
        this.type = type;
        this.description = description;
    }

    /**
     * 类型
     */
    private Integer type;

    /**
     * 描述,现用于匹配规则判断类型
     */
    private String description;

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
