package com.bxm.fossicker.message.enums;

/**
 * 通知类型,同一种通知类型在不同的通知渠道构成的消息不同，详见service模块中对枚举的使用
 *
 * @author liujia
 * @date 2020/03/27 13:53
 */
public enum NotifyEnum {
    /**
     * 饿了么订单自购成功
     */
    ELE_PURCHASE_ORDER_SUCCESS,

    /**
     * 饿了么分享订单成功
     */
    ELE_SHARE_ORDER_SUCCESS,

    /**
     * 同步到用户的0元购订单
     */
    ZERO_COMMODITY_ORDER_SYNC,

    /**
     * 用户0元购订单生效
     */
    ZERO_COMMODITY_ORDER_SUCCESS,

    /**
     * 邀请奖励到账
     */
    INVITE_AWARD,

    /**
     * 0元抽奖活动开奖通知
     */
    INDIANAPOLIS_DRAW_MSG,

    /**
     * 昨日获取金币超过5000的用户推送
     */
    YESTERDAY_GOLD_THAN_5000,

    /**
     * 自购成功后给上级、上上级的消息通知
     */
    APPRENTICED_INVITE_FINISH_ORDER,

    /**
     * 分享商品佣金到账的消息
     */
    SHARE_MONEY_FINISH_ORDER,

    /**
     * 自购成功后的到账消息
     */
    SELF_BUY_FINISH_ORDER,

    /**
     * 邀请好友成功
     */
    INVITE_SUCCESS,
}
