package com.bxm.fossicker.message.enums;

/**
 * 推送策略，可用于组成策略数组构成推送的先后顺序
 */
public enum PushStrategyEnum {
    /**
     * 用户未开启推送时，使用短信推送
     */
    SMS,

    /**
     * 用户未开启推送，使用公众号补偿推送
     */
    WECHAT,

    /**
     * 使用正常推送策略
     */
    APP,

    /**
     * 最大尝试策略，根据通知策略优先级（app > wechat > sms）进行尝试，在某一种方式成功后终止
     */
    MAX_ATTEMPT,
}
