package com.bxm.fossicker.message.enums;

public enum SmsTempEnum {
    /**
     * 登录短信
     */
    LOGIN("【惠好省】您的验证码为 {}，请勿向他人泄露。", SmsTypeEnum.SMS_CODE),
    /**
     * 重置密码短信
     */
    RESET("【惠好省】您的验证码为 {}，请勿向他人泄露。", SmsTypeEnum.SMS_CODE),
    /**
     * 绑定手机号码短信
     */
    BIND("【惠好省】您的验证码为 {}，请勿向他人泄露。", SmsTypeEnum.SMS_CODE),

    /**
     * 大王卡活动
     */
    UNCICOME("【服务提醒】您的验证码为：{}，在5分钟内有效。如非本人操作请忽略此短信。", SmsTypeEnum.SMS_CODE),

    // -----------------------以上是验证码模板------------------------------------

    /**
     * 邀请亲友短信
     * 写在配置文件中
     * 模板：【惠好省】有人@你，你有一份新人专享礼品即将到期，戳 https://webtest.91huola.com/h5/fossicker/download_gold.html?shareUserId={$var} 速速领取！退订回T
     */
    RELATIVE_INVITE("relativeInviteSms", SmsTypeEnum.ARGUMENT_FROM_CONFIG_253),

    /**
     * 自购完成订单的用户
     * 【惠好省】你有一笔自购佣金{$money}元已经跟单成功（淘宝订单{$order}），坐等结算提现吧～戳+链接+查看详情{$url}
     */
    SELF_BUY_FINISH_ORDER("selfBuyFinishOrder", SmsTypeEnum.ARGUMENT_FROM_CONFIG_253),
    /**
     * 徒弟完成订单的用户
     * 你有一笔好友贡献佣金{$money}元已经跟单成功（淘宝订单{$order}），坐等结算提现吧～戳+链接+查看详情{$url}
     */
    APPRENTICED_INVITE_FINISH_ORDER("apprenticedInviteFinishOrder", SmsTypeEnum.ARGUMENT_FROM_CONFIG_253),

    /**
     * 分享的用户
     * 【惠好省】你有一笔分享佣金{$money}元已经跟单成功（淘宝订单.$order}），坐等结算提现吧～戳+链接+查看详情{$url}
     */
    SHARE_MONEY_FINISH_ORDER("shareMoneyFinishOrder", SmsTypeEnum.ARGUMENT_FROM_CONFIG_253),

    /**
     * 昨日总金币5000及以上的用户
     * 【惠好省】恭喜，您昨日总共获得{$gold}金币，再接再厉哦。戳+链接+查看详情{$url}
     */
    YESTERDAY_GOLD_THAN_5000("yesterdayGoldThan5000", SmsTypeEnum.ARGUMENT_FROM_CONFIG_253),
    /**
     * 获得历史奖励的老用户（徒弟中有下载登录）
     * 【惠好省】 邀请好友规则升级福利！您的历史好友中有{$var}位已下载惠好省app并登录，奖励{$money}元已入账，速戳+链接+查看{$url}
     */
    HISTORY_FRIEND_INSTALL_APP("historyFriendInstallApp", SmsTypeEnum.ARGUMENT_FROM_CONFIG_253),

    /**
     * 饿了么自购订单结算成功
     * 你有一笔饿了么补贴${var}元已经结算成功（订单${var}），可提现～戳+链接+查看详情{$url}
     */
    ELE_PURCHASE_ORDER_SUCCESS("elePurchaseOrderSuccess", SmsTypeEnum.ARGUMENT_FROM_CONFIG_253),

    /**
     * 饿了么分享订单结算成功
     * 你有一笔饿了么补贴${var}元已经结算成功（订单${var}），可提现～戳+链接+查看详情{$url}
     */
    ELE_SHARE_ORDER_SUCCESS("eleShareOrderSuccess", SmsTypeEnum.ARGUMENT_FROM_CONFIG_253),

    /**
     * V1.6.3 饿了么通用通知短信
     * 你有一笔饿了么补贴已经结算成功（订单...{s}），再来一单吧～戳 https://t.91huola.com/r{s} 查看详情
     */
    ELE_COMMON_ORDER_SUCCESS("eleCommonOrderSuccess", SmsTypeEnum.ARGUMENT_FROM_CONFIG_253),

    /**
     * 0元购订单跟单成功
     * 你有一笔0元购订单已跟单成功（订单${var}），赶快邀请好友领全额返佣吧～戳+链接+查看详情{$url}
     */
    ZERO_COMMODITY_ORDER_SYNC("zeroCommodityOrderSync", SmsTypeEnum.ARGUMENT_FROM_CONFIG_253),

    /**
     * 0元购订单跟单成功
     * <p>
     * 你有一笔0元购订单已生效（订单${var}），返佣${var}元，坐等结算提现吧～戳+链接+查看详情 {$url}
     */
    ZERO_COMMODITY_ORDER_SUCCESS("zeroCommodityOrderSuccess", SmsTypeEnum.ARGUMENT_FROM_CONFIG_253),

    /**
     * 邀请获得的奖励
     * 你的好友为你贡献了一笔现金收益，速速打开app提现吧～戳+链接+查看详情
     */
    INVITE_AWARD("inviteAward", SmsTypeEnum.ARGUMENT_FROM_CONFIG_253),

    /**
     * V1.6.3 购物返佣入账通用短信
     * 你有一笔{s}佣金已经跟单成功（淘宝订单....{s}），坐等结算提现吧～戳https://t.91huola.com/r?t=b查看详情退订回T
     */
    COMMON_ORDER_ENTRY("commonOrderEntry", SmsTypeEnum.ARGUMENT_FROM_CONFIG_253),

    /**
     * 实体卡发货
     * 您的惠好省黑钻卡已发货，物流单号【{s}】{s}。可使用收货人手机号登录惠好省APP，提前享受会员权益！
     */
    REALITY_CARD_DELIVER("realityCardDeliver", SmsTypeEnum.ARGUMENT_FROM_CONFIG_253),

    /**
     * 提醒好友
     * 写在配置文件中
     * 模板：【惠好省】今日还可领取12000金币，今天24:00不领作废！金币余额可提走，速来戳 https://webtest.91huola.com/h5/fossicker/download_gold.html?shareUserId={$var} 退订回T
     */
    REIMNDER_SMS("【惠好省】Hi，好友提醒你今日还可领取12000金币，今天24:00不领作废！金币余额可提走，速来领噢～ 退订回T", SmsTypeEnum.ARGUMENT_253),

    /**
     * 邀请获得的奖励
     * 恭喜您成为惠好省终身黑钻会员！请在24小时内使用本机号码登录激活。激活方式：应用市场搜索“惠好省”。
     */
    @Deprecated
    TO_BE_VIP_OUT_SIDE("toBeVipOutSide", SmsTypeEnum.ARGUMENT_FROM_CONFIG_253),

    /**
     * 昨日注册但是未激活的VIP用户
     * 尊敬的惠好省黑钻会员，您的专属激活码为RYJUQV，请尽快激活，过期失效！激活方式：应用市场搜索“惠好省”并用本机号码登录。
     */
    @Deprecated
    YESTERDAY_UNACTIVE_VIP("yesterdayUnactiveVip", SmsTypeEnum.ARGUMENT_FROM_CONFIG_253),

    /**
     * 前日注册但是未激活的VIP用户
     * 您的会员权益即将失效！请在24小时内使用本机号码登录，激活终身会员，专属激活码为RYJUQV。激活方式：应用市场搜索“惠好省”并用本机号码登录。
     */
    @Deprecated
    BEFORE_YESTERDAY_UNACTIVE_VIP("beforeYesterdayUnactiveVip", SmsTypeEnum.ARGUMENT_FROM_CONFIG_253),

    /**
     * 昨日注册但是未激活的VIP用户
     * 尊敬的惠好省黑钻会员，您的专属激活码为RYJUQV，请尽快激活，过期失效！戳+链接+立即下载APP激活
     */
    YESTERDAY_UNACTIVE_VIP2("尊敬的惠好省黑钻会员，您的专属激活码为%s，请尽快激活，过期失效！戳 %s 立即下载APP激活", SmsTypeEnum.ARGUMENT_DREAM_WEB),

    /**
     * 前日注册但是未激活的VIP用户
     * 您的会员权益即将失效！请在24小时内使用本机号码登录，激活终身会员，专属激活码为RYJUQV。戳+链接+立即下载APP激活
     */
    BEFORE_YESTERDAY_UNACTIVE_VIP2("您的会员权益即将失效！请在24小时内使用本机号码登录，激活终身会员，专属激活码为%s。戳 %s 立即下载APP激活", SmsTypeEnum.ARGUMENT_DREAM_WEB),

    /**
     * 邀请获得的奖励
     * 恭喜您成为惠好省终身黑钻会员！下载惠好省APP，使用办卡时填写的手机号登录激活。戳%s立即下载
     */
    TO_BE_VIP_OUT_SIDE2("恭喜您成为惠好省终身黑钻会员！下载惠好省APP，使用办卡时填写的手机号登录激活。戳 %s 立即下载",
            SmsTypeEnum.ARGUMENT_DREAM_WEB),
    ;

    /**
     * 短信模板 or 从配置文件中获取短信模板的key
     */
    private String template;

    /**
     * 1: 验证码
     * 2: 根据 template 的值查找配置文件对应的短信模板
     */
    private SmsTypeEnum smsType;

    SmsTempEnum(String template, SmsTypeEnum smsType) {
        this.template = template;
        this.smsType = smsType;
    }

    public String getTemplate() {
        return template;
    }

    public SmsTypeEnum getSmsType() {
        return smsType;
    }
}