package com.bxm.fossicker.message.vo;

import lombok.Data;

/**
 * 用户推送相关的原始数据
 *
 * @author liujia
 * @date 2020/03/27 14:56
 */
@Data
public class UserPushInfo {
    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 推送token值
     */
    private String pushToken;

    /**
     * 推送的平台
     */
    private String pushPlatform;

    /**
     * 微信公众号token(oid)，用于推送到公众号
     */
    private String wechatToken;

    /**
     * 用户手机号码
     */
    private String phoneNo;

    /**
     * 用户设备是否开启了推送
     */
    private Boolean enableNotify;

    /**
     * 设备模型、ios还是安卓
     */
    private int phoneModel;
}
