/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.message.param;

import com.bxm.fossicker.message.enums.NotifyEnum;
import com.bxm.fossicker.message.enums.NotifyParamEnum;
import com.bxm.fossicker.message.enums.PushStrategyEnum;
import com.bxm.fossicker.message.vo.UserPushInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MixPushParam {
    private List<PushStrategyEnum> strategyList;
    private Long userId;
    private NotifyEnum notifyType;
    private Map<NotifyParamEnum, Object> extendMap;
    private UserPushInfo userPushInfo;

    private MixPushParam() {
    }

    public static MixPushParamBuilder builder() {
        MixPushParam param = new MixPushParam();
        param.strategyList = new ArrayList<PushStrategyEnum>();
        param.extendMap = new HashMap<NotifyParamEnum, Object>(5);
        return new MixPushParamBuilder(param);
    }

    public MixPushParam removeStrategy(PushStrategyEnum pushStrategy) {
        this.strategyList.remove((Object)pushStrategy);
        return this;
    }

    public MixPushParam setUserPushInfo(UserPushInfo userPushInfo) {
        this.userPushInfo = userPushInfo;
        return this;
    }

    public boolean valid() {
        return this.getUserId() != null && this.getNotifyType() != null && this.getStrategyList().size() != 0;
    }

    public List<PushStrategyEnum> getStrategyList() {
        return this.strategyList;
    }

    public Long getUserId() {
        return this.userId;
    }

    public NotifyEnum getNotifyType() {
        return this.notifyType;
    }

    public Map<NotifyParamEnum, Object> getExtendMap() {
        return this.extendMap;
    }

    public <T> T get(NotifyParamEnum key) {
        return (T)this.extendMap.get((Object)key);
    }

    public UserPushInfo getUserPushInfo() {
        return this.userPushInfo;
    }

    public String toString() {
        return "MixPushParam(strategyList=" + this.getStrategyList() + ", userId=" + this.getUserId() + ", notifyType=" + (Object)((Object)this.getNotifyType()) + ", extendMap=" + this.getExtendMap() + ", userPushInfo=" + this.getUserPushInfo() + ")";
    }

    public static class MixPushParamBuilder {
        private MixPushParam param;

        MixPushParamBuilder(MixPushParam param) {
            this.param = param;
        }

        public MixPushParamBuilder addStrategy(PushStrategyEnum pushStrategy) {
            this.param.strategyList.add(pushStrategy);
            return this;
        }

        public MixPushParamBuilder notifyType(NotifyEnum notifyType) {
            this.param.notifyType = notifyType;
            return this;
        }

        public MixPushParamBuilder addExtend(NotifyParamEnum key, Object value) {
            this.param.extendMap.put(key, value);
            return this;
        }

        public MixPushParamBuilder userId(Long userId) {
            this.param.userId = userId;
            return this;
        }

        public MixPushParam build() {
            if (this.param.strategyList.size() == 0) {
                this.param.strategyList.add(PushStrategyEnum.APP);
            }
            if (this.param.strategyList.contains((Object)PushStrategyEnum.MAX_ATTEMPT)) {
                this.param.strategyList.clear();
                this.param.strategyList.add(PushStrategyEnum.APP);
                this.param.strategyList.add(PushStrategyEnum.WECHAT);
                this.param.strategyList.add(PushStrategyEnum.SMS);
            }
            return this.param;
        }
    }
}

