package com.bxm.fossicker.message.domain;

import com.bxm.fossicker.message.entity.MessageBean;
import com.bxm.fossicker.message.entity.Tuple;
import com.bxm.fossicker.message.param.MessageListParam;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface MessageMapper {

    int insertSelective(MessageBean record);

    MessageBean selectByPrimaryKey(@Param("id") Integer id, @Param("userId") Long userId);

    int updateByUserId(MessageBean message);

    int updateMsg(@Param("id") Integer id, @Param("status") Byte status, @Param("userId") Long userId);

    List<MessageBean> listMessage(MessageListParam messageListParam);

    int countMessage(@Param("userId") Long userId);

    int updateMessageByType(MessageListParam messageListParam);

    /**
     * 获取各个类型未读消息的数量
     * @param userId 用户ID
     * @return 未读消息的类型和数量
     */
    List<Tuple> getUnreadMap(Long userId);

    /**
     * 获取用户的各种类型的最后一条消息
     * @param userId 用户ID
     * @return 最后一条消息列表
     */
    List<MessageBean> getLastMsg(Long userId);
}
