package com.bxm.fossicker.order.controller;

import com.bxm.fossicker.order.model.dto.MeituanOrderSourceInfo;
import com.bxm.fossicker.order.service.MeituanTakeOutOrderService;
import com.bxm.newidea.component.annotations.ApiVersion;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 多麦订单回调接口
 * @Author: Gonzo
 * @date  2020-03-25 17:47
 * @since 1.6.1
 */
@Api(tags = "05-05 多麦订单回调接口", description = "多麦订单回调接口")
@RestController
@RequestMapping("{version}/order/public/callback/duomai")
public class DuomaiCallBackController {

    @Autowired
    private MeituanTakeOutOrderService meituanTakeOutOrderService;

    @ApiVersion(1)
    @GetMapping("")
    @ApiOperation(value = "5-05-1 多麦订单回调接口", notes = "多麦订单回调接口")
    public Integer orderCallBack(MeituanOrderSourceInfo orderInfo) {
        return meituanTakeOutOrderService.orderNotice(orderInfo);
    }

}
