package com.bxm.fossicker.order.controller;

import com.bxm.fossicker.order.model.param.AddOrderHandParam;
import com.bxm.fossicker.order.model.param.UserOrderParam;
import com.bxm.fossicker.order.model.vo.UserOrderInfoVO;
import com.bxm.fossicker.order.service.OrderCommissionService;
import com.bxm.fossicker.order.service.OrderService;
import com.bxm.fossicker.order.service.PullOrderService;
import com.bxm.fossicker.user.facade.UserPayorderInfoFacadeService;
import com.bxm.fossicker.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import java.util.List;

/**
 * Created by Gonzo on 2019-07-23.
 */
@Api(tags = "05-01 订单接口", description = "订单信息相关接口")
@RestController
@RequestMapping("order/info")
public class OrderController {


    private final OrderService orderService;

    private final PullOrderService pullOrderService;

    private final UserPayorderInfoFacadeService userPayorderInfoFacadeService;

    private final OrderCommissionService orderCommissionService;

    @Autowired
    public OrderController(OrderService orderService,
                           PullOrderService pullOrderService,
                           UserPayorderInfoFacadeService userPayorderInfoFacadeService,
                           OrderCommissionService orderCommissionService) {
        this.orderService = orderService;
        this.pullOrderService = pullOrderService;
        this.userPayorderInfoFacadeService = userPayorderInfoFacadeService;
        this.orderCommissionService = orderCommissionService;
    }

    @ApiOperation(value = "05-01-01 获取用户订单列表", notes = "返回指定状态的用户订单列表")
    @ApiImplicitParam(name = "userId", value = "用户ID")
    @GetMapping("user/list")
    public ResponseJson<List<UserOrderInfoVO>> getUserOrder(UserOrderParam param) {
        return ResponseJson.ok(orderService.getUserOrder(param));
    }

    @PostMapping("/hand")
    public ResponseJson<Boolean> handOrderInfo(@RequestBody AddOrderHandParam addOrderHandParam) {
        return ResponseJson.ok(pullOrderService.addOrderByHand(addOrderHandParam));
    }

    @ApiOperation(value = "05-01-02 获取订单状态同步接口", notes = "返回订单支付状态0：待支付 1：支付成功 2：取消支付 3：支付超时 ")
    @ApiImplicitParams({
            @ApiImplicitParam(value = "orderNo", name = "订单号", required = true, paramType = "string"),
            @ApiImplicitParam(value = "userId", name = "用户id", required = true, paramType = "Long")
    })
    @GetMapping("wxorder/getStatus")
    public ResponseJson<String> getWxOrderStatus(@ApiIgnore @RequestParam String orderNo, @ApiIgnore @RequestParam Long userId) {
        return ResponseJson.ok(userPayorderInfoFacadeService.getWxOrderStatus(orderNo, userId));
    }
}
