package com.bxm.fossicker.order.controller;

import com.bxm.fossicker.activity.facade.TaskFacadeService;
import com.bxm.fossicker.activity.facade.enums.ActivityFacadeEnum;
import com.bxm.fossicker.order.model.param.RelationInfoRspDTO;
import com.bxm.fossicker.order.service.OrderRelationUserService;
import com.bxm.fossicker.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author: pf.w
 * @Date: 2019/7/23 14:33
 */
@Api(tags = "5-02 订单授权相关", description = "授权获取用户信息相关")
@RestController
@RequestMapping("/order/relationUser")
@Slf4j
public class OrderRelationUserController {

    @Autowired
    private OrderRelationUserService orderRelationUserService;
    @Autowired
    private TaskFacadeService taskFacadeService;

    @ApiOperation(value = "5-02-1 绑定用户渠道ID ,会员ID", notes = "绑定用户渠道ID ,会员ID")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "code", value = "用户授权后的code", required = true),
            @ApiImplicitParam(name = "userId", value = "用户Id,等同于淘宝授权回调的state参数", required = true)
    })
    @GetMapping("/relateUserInfo")
    public ResponseJson<RelationInfoRspDTO> relateUserInfo(Long userId, String code){
        log.info("绑定会员关系 入参 userId: {},code:{}",userId,code);
        RelationInfoRspDTO result = new RelationInfoRspDTO();
        try{
            result =  orderRelationUserService.relateUserInfo(userId,code);
            if(result.isOk()){
                //完成新用户授权任务
                taskFacadeService.complete(userId, ActivityFacadeEnum.AUTH_TAOBAO);
            }
        }catch (Exception e){
            log.error("绑定会员关系 error "+e);
        }
        return ResponseJson.ok(result);
    }

    @ApiOperation(value = "5-02-2 查看用户是否绑定会员信息接口", notes = "查看用户是否绑定会员信息接口")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户Id", required = true)
    })
    @GetMapping("/checkRelation")
    public ResponseJson<RelationInfoRspDTO> checkRelation(Long userId){
        return ResponseJson.ok(orderRelationUserService.isBandTB(userId));
    }
}
