package com.bxm.fossicker.order.controller;

import com.bxm.fossicker.order.facade.service.SynchronizeOrderService;
import com.bxm.fossicker.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;

/**
 * @Author: pf.w
 * @Date: 2019/8/26 13:42
 */
@Api(tags = "1-11", description = "手动触发定时更新订单接口")
@RestController
@RequestMapping("order/public/quartz")
@Slf4j
public class QuartzOrderController {

    @Autowired
    private SynchronizeOrderService synchronizeOrderService;

    @ApiOperation(value = "1-11-1  更新订单状态", notes = "更新订单状态")
    @PostMapping("/updateOrderStatus")
    public ResponseJson updateOrderStatus(){
        log.info("----手动触发更新订单状态开始   start", LocalDateTime.now());

        try {
            synchronizeOrderService.synchronOrderStatus();
        } catch (Exception e) {
            log.error("手动触发更新订单状态,异常为:", e);
        }
        log.info("----手动触发更新订单状态开始   end", LocalDateTime.now());
        return ResponseJson.ok();
    }

    @ApiOperation(value = "1-11-2 添加消息推送的定时任务(仅运行一次)", notes = "运营后台配置了定时push时，进行定时推送")
    @PostMapping("/payCash")
    public ResponseJson payCash(){
        log.info("----手动触发返佣开始   start", LocalDateTime.now());

        try {
            synchronizeOrderService.payCashForLastMonthOrder();
        } catch (Exception e) {
            log.error("手动触发返佣开始,异常为:", e);
        }
        log.info("----手动触发返佣开始   end", LocalDateTime.now());
        return ResponseJson.ok();
    }

}
