package com.bxm.fossicker.order.controller;

import com.bxm.fossicker.order.model.param.TakeOutJumpInfoParam;
import com.bxm.fossicker.order.model.param.TakeOutOrderParam;
import com.bxm.fossicker.order.model.param.UserIdParam;
import com.bxm.fossicker.order.model.vo.EleTaoWord;
import com.bxm.fossicker.order.model.vo.JumpInfo;
import com.bxm.fossicker.order.model.vo.TakeOutOrderInfoVO;
import com.bxm.fossicker.order.service.TakeOutOrderService;
import com.bxm.fossicker.vo.ResponseJson;
import com.bxm.newidea.component.annotations.ApiVersion;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Api(tags = "05-04 外卖订单接口", description = "订单信息相关接口")
@RestController
@RequestMapping("{version}/order/info/takeOut")
public class TakeOutOrderController {

    @Autowired
    private TakeOutOrderService takeOutOrderService;

    @ApiVersion(1)
    @GetMapping("list")
    @ApiOperation(value = "5-04-1 获取用户外卖订单", notes = "传入类型、分页参数，获取用户外卖订单")
    public ResponseJson<List<TakeOutOrderInfoVO>> getTakeOutList(TakeOutOrderParam param) {
        return ResponseJson.ok(takeOutOrderService.getTakeOutList(param));
    }

    @ApiVersion(1)
    @GetMapping("jumpInfo")
    @ApiOperation(value = "5-04-2 获取跳转外卖跳转链接", notes = "根据用户id 获取美团 or 饿了么跳转链接")
    public ResponseJson<JumpInfo> getJumpInfo(TakeOutJumpInfoParam param) {
        return takeOutOrderService.getJumpInfo(param);
    }

    @ApiVersion(1)
    @GetMapping("ele/taoWord")
    @ApiOperation(value = "5-04-3 获取饿了么淘口令", notes = "根据用户id 获取饿了么淘口令")
    public ResponseJson<EleTaoWord> getEleTaoWord(UserIdParam param) {
        return takeOutOrderService.getEleTaoWord(param);
    }


}
