package com.bxm.fossicker.order.controller;

import com.bxm.fossicker.order.model.param.ListAllVipZeroOrderParam;
import com.bxm.fossicker.order.model.param.UserIdParam;
import com.bxm.fossicker.order.model.vo.UserVipZeroCommodityOrderInfoVO;
import com.bxm.fossicker.order.service.VipZeroCommodityOrderService;
import com.bxm.fossicker.vo.ResponseJson;
import com.bxm.newidea.component.annotations.ApiVersion;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

@Api(tags = "5-03 会员0元购订单", description = "会员0元购订单相关接口")
@RestController
@RequestMapping("{version}/order/vip/zero")
@Slf4j
public class VipZeroCommodityOrderController {

    @Resource
    private VipZeroCommodityOrderService vipZeroCommodityOrderService;


    @ApiOperation(value = "05-03-01  获取用户vip 0元购订单", notes = "获取用户vip 0元购订单-带分页")
    @GetMapping("list")
    @ApiVersion(1)
    public ResponseJson<List<UserVipZeroCommodityOrderInfoVO>> listAll(ListAllVipZeroOrderParam param) {
        return ResponseJson.ok(vipZeroCommodityOrderService.listAll(param));
    }

    @ApiOperation(value = "05-03-02  是否可以下vip 0元购订单", notes = "是否可以下vip 0元购订单")
    @GetMapping("canOrder")
    @ApiVersion(1)
    public ResponseJson<Boolean> canOrderVipZeroCommodity(UserIdParam param) {
        return ResponseJson.ok(vipZeroCommodityOrderService.canOrderVipZeroCommodity(param));
    }

}
