/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.order.controller;

import com.bxm.fossicker.order.model.param.AddOrderHandParam;
import com.bxm.fossicker.order.model.param.UserOrderParam;
import com.bxm.fossicker.order.model.vo.UserOrderInfoVO;
import com.bxm.fossicker.order.service.OrderCommissionService;
import com.bxm.fossicker.order.service.OrderService;
import com.bxm.fossicker.order.service.PullOrderService;
import com.bxm.fossicker.user.facade.UserPayorderInfoFacadeService;
import com.bxm.fossicker.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"05-01 \u8ba2\u5355\u63a5\u53e3"}, description="\u8ba2\u5355\u4fe1\u606f\u76f8\u5173\u63a5\u53e3")
@RestController
@RequestMapping(value={"order/info"})
public class OrderController {
    private final OrderService orderService;
    private final PullOrderService pullOrderService;
    private final UserPayorderInfoFacadeService userPayorderInfoFacadeService;
    private final OrderCommissionService orderCommissionService;

    @Autowired
    public OrderController(OrderService orderService, PullOrderService pullOrderService, UserPayorderInfoFacadeService userPayorderInfoFacadeService, OrderCommissionService orderCommissionService) {
        this.orderService = orderService;
        this.pullOrderService = pullOrderService;
        this.userPayorderInfoFacadeService = userPayorderInfoFacadeService;
        this.orderCommissionService = orderCommissionService;
    }

    @ApiOperation(value="05-01-01 \u83b7\u53d6\u7528\u6237\u8ba2\u5355\u5217\u8868", notes="\u8fd4\u56de\u6307\u5b9a\u72b6\u6001\u7684\u7528\u6237\u8ba2\u5355\u5217\u8868")
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID")
    @GetMapping(value={"user/list"})
    public ResponseJson<List<UserOrderInfoVO>> getUserOrder(UserOrderParam param) {
        return ResponseJson.ok((Object)this.orderService.getUserOrder(param));
    }

    @PostMapping(value={"/hand"})
    public ResponseJson<Boolean> handOrderInfo(@RequestBody AddOrderHandParam addOrderHandParam) {
        return ResponseJson.ok((Object)this.pullOrderService.addOrderByHand(addOrderHandParam));
    }

    @ApiOperation(value="05-01-02 \u83b7\u53d6\u8ba2\u5355\u72b6\u6001\u540c\u6b65\u63a5\u53e3", notes="\u8fd4\u56de\u8ba2\u5355\u652f\u4ed8\u72b6\u60010\uff1a\u5f85\u652f\u4ed8 1\uff1a\u652f\u4ed8\u6210\u529f 2\uff1a\u53d6\u6d88\u652f\u4ed8 3\uff1a\u652f\u4ed8\u8d85\u65f6 ")
    @ApiImplicitParams(value={@ApiImplicitParam(value="orderNo", name="\u8ba2\u5355\u53f7", required=true, paramType="string"), @ApiImplicitParam(value="userId", name="\u7528\u6237id", required=true, paramType="Long")})
    @GetMapping(value={"wxorder/getStatus"})
    public ResponseJson<String> getWxOrderStatus(@ApiIgnore @RequestParam String orderNo, @ApiIgnore @RequestParam Long userId) {
        return ResponseJson.ok((Object)this.userPayorderInfoFacadeService.getWxOrderStatus(orderNo, userId));
    }
}

