/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.order.controller;

import com.bxm.fossicker.activity.facade.TaskFacadeService;
import com.bxm.fossicker.activity.facade.enums.ActivityFacadeEnum;
import com.bxm.fossicker.order.model.param.RelationInfoRspDTO;
import com.bxm.fossicker.order.service.OrderRelationUserService;
import com.bxm.fossicker.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"5-02 \u8ba2\u5355\u6388\u6743\u76f8\u5173"}, description="\u6388\u6743\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u76f8\u5173")
@RestController
@RequestMapping(value={"/order/relationUser"})
public class OrderRelationUserController {
    private static final Logger log = LoggerFactory.getLogger(OrderRelationUserController.class);
    @Autowired
    private OrderRelationUserService orderRelationUserService;
    @Autowired
    private TaskFacadeService taskFacadeService;

    @ApiOperation(value="5-02-1 \u7ed1\u5b9a\u7528\u6237\u6e20\u9053ID ,\u4f1a\u5458ID", notes="\u7ed1\u5b9a\u7528\u6237\u6e20\u9053ID ,\u4f1a\u5458ID")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="\u7528\u6237\u6388\u6743\u540e\u7684code", required=true), @ApiImplicitParam(name="userId", value="\u7528\u6237Id,\u7b49\u540c\u4e8e\u6dd8\u5b9d\u6388\u6743\u56de\u8c03\u7684state\u53c2\u6570", required=true)})
    @GetMapping(value={"/relateUserInfo"})
    public ResponseJson<RelationInfoRspDTO> relateUserInfo(Long userId, String code) {
        log.info("\u7ed1\u5b9a\u4f1a\u5458\u5173\u7cfb \u5165\u53c2 userId: {},code:{}", (Object)userId, (Object)code);
        RelationInfoRspDTO result = new RelationInfoRspDTO();
        try {
            result = this.orderRelationUserService.relateUserInfo(userId, code);
            if (result.isOk()) {
                this.taskFacadeService.complete(userId, ActivityFacadeEnum.AUTH_TAOBAO);
            }
        }
        catch (Exception e) {
            log.error("\u7ed1\u5b9a\u4f1a\u5458\u5173\u7cfb error " + e);
        }
        return ResponseJson.ok((Object)result);
    }

    @ApiOperation(value="5-02-2 \u67e5\u770b\u7528\u6237\u662f\u5426\u7ed1\u5b9a\u4f1a\u5458\u4fe1\u606f\u63a5\u53e3", notes="\u67e5\u770b\u7528\u6237\u662f\u5426\u7ed1\u5b9a\u4f1a\u5458\u4fe1\u606f\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237Id", required=true)})
    @GetMapping(value={"/checkRelation"})
    public ResponseJson<RelationInfoRspDTO> checkRelation(Long userId) {
        return ResponseJson.ok((Object)this.orderRelationUserService.isBandTB(userId));
    }
}

