/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.order.controller.internal;

import com.bxm.fossicker.enums.UserJudgeMarkerEnum;
import com.bxm.fossicker.order.model.param.SyncOrderParam;
import com.bxm.fossicker.order.service.EleTakeOutOrderService;
import com.bxm.fossicker.order.service.MeituanTakeOutOrderService;
import com.bxm.fossicker.order.service.OrderRefundService;
import com.bxm.fossicker.order.service.TakeOutOrderService;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.fossicker.vo.ResponseJson;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"05-06 \u8ba2\u5355\u5185\u90e8\u89e6\u53d1\u63a5\u53e3"}, description="\u8ba2\u5355\u5185\u90e8\u89e6\u53d1\u63a5\u53e3")
@RestController
@RequestMapping(value={"{version}/order/internal"})
public class TakeOutOrderInternalController {
    private final MeituanTakeOutOrderService meituanTakeOutOrderService;
    private final EleTakeOutOrderService eleTakeOutOrderService;
    private final TakeOutOrderService takeOutOrderService;
    private final UserInfoFacadeService userInfoFacadeService;
    private final RedisSetAdapter redisSetAdapter;
    private final OrderRefundService orderRefundService;

    @ApiVersion(value=1)
    @GetMapping(value={"syncMeituanOrder"})
    @ApiOperation(value="5-06-1 \u624b\u52a8\u89e6\u53d1\u8fdb\u884c\u591a\u9ea6\u8ba2\u5355\u7684\u4fe1\u606f\u540c\u6b65", notes="\u624b\u52a8\u89e6\u53d1\u8fdb\u884c\u591a\u9ea6\u8ba2\u5355\u7684\u4fe1\u606f\u540c\u6b65")
    public ResponseJson syncMeituanOrder(SyncOrderParam param) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        this.meituanTakeOutOrderService.syncOrder(StringUtils.isBlank((CharSequence)param.getTimeFrom()) ? null : LocalDateTime.parse(param.getTimeFrom(), formatter), StringUtils.isBlank((CharSequence)param.getTimeTo()) ? null : LocalDateTime.parse(param.getTimeTo(), formatter), StringUtils.isBlank((CharSequence)param.getChargeFrom()) ? null : LocalDateTime.parse(param.getChargeFrom(), formatter), StringUtils.isBlank((CharSequence)param.getChargeTo()) ? null : LocalDateTime.parse(param.getChargeTo(), formatter));
        return ResponseJson.ok();
    }

    @ApiVersion(value=1)
    @GetMapping(value={"syncEleOrder"})
    @ApiOperation(value="5-06-2 \u624b\u52a8\u89e6\u53d1\u8fdb\u884c\u997f\u4e86\u4e48\u8ba2\u5355\u7684\u4fe1\u606f\u540c\u6b65", notes="\u624b\u52a8\u89e6\u53d1\u8fdb\u884c\u997f\u4e86\u4e48\u8ba2\u5355\u7684\u4fe1\u606f\u540c\u6b65")
    public ResponseJson syncEleOrder(SyncOrderParam param) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime start = LocalDateTime.parse(param.getTimeFrom(), formatter);
        LocalDateTime end = LocalDateTime.parse(param.getTimeTo(), formatter);
        while (start.isBefore(end)) {
            LocalDateTime localDateTime = start;
            start = start.plusHours(1L);
            this.eleTakeOutOrderService.syncOrderStatus(localDateTime, start);
        }
        return ResponseJson.ok();
    }

    @ApiVersion(value=1)
    @GetMapping(value={"firstTakeOutOrderUserJudgemark"})
    @ApiOperation(value="5-06-3 \u624b\u52a8\u89e6\u53d1\u5c06\u5df2\u4e0b\u5916\u5356\u8ba2\u5355\u7528\u6237\u8fdb\u884c\u6807\u5fd7\u4f4d\u586b\u5145", notes="\u624b\u52a8\u89e6\u53d1\u5c06\u5df2\u4e0b\u5916\u5356\u8ba2\u5355\u7528\u6237\u8fdb\u884c\u6807\u5fd7\u4f4d\u586b\u5145")
    public ResponseJson firstTakeOutOrderUserJudgeMark() {
        this.takeOutOrderService.firstTakeOutOrderUserJudgeMark();
        return ResponseJson.ok();
    }

    @ApiOperation(value="5-06-4 \u624b\u52a8\u89e6\u53d1\u5df2\u4e0b\u5546\u54c1\u8d2d\u7269\u5355\u7528\u6237\u9884\u70ed\u6807\u8bc6\u4f4d", notes="\u624b\u52a8\u89e6\u53d1\u5df2\u4e0b\u5355\u7528\u6237\u9884\u70ed\u6807\u8bc6\u4f4d")
    @GetMapping(value={"orderUserPreLoading"})
    public ResponseJson firstOrderUserJudgeMark() {
        Set allMembers = this.redisSetAdapter.getAllMembers((KeyGenerator)DefaultKeyGenerator.build().setModule("order").setGroup("newbie").setKey("user"), Long.class);
        allMembers.forEach(p -> this.userInfoFacadeService.addJudgeMark(p, UserJudgeMarkerEnum.COMMODITY_ORDERED));
        return ResponseJson.ok();
    }

    @ApiOperation(value="5-06-5 \u624b\u52a8\u89e6\u53d1\u62c9\u53d6\u7ef4\u6743\u8ba2\u5355", notes="\u624b\u52a8\u89e6\u53d1\u62c9\u53d6\u7ef4\u6743\u8ba2\u5355")
    @GetMapping(value={"pullRefundOrder"})
    public ResponseJson pullRefundOrder(String startTime) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime start = LocalDateTime.parse(startTime, formatter);
        this.orderRefundService.pullRefundOrder(start);
        return ResponseJson.ok();
    }

    public TakeOutOrderInternalController(MeituanTakeOutOrderService meituanTakeOutOrderService, EleTakeOutOrderService eleTakeOutOrderService, TakeOutOrderService takeOutOrderService, UserInfoFacadeService userInfoFacadeService, RedisSetAdapter redisSetAdapter, OrderRefundService orderRefundService) {
        this.meituanTakeOutOrderService = meituanTakeOutOrderService;
        this.eleTakeOutOrderService = eleTakeOutOrderService;
        this.takeOutOrderService = takeOutOrderService;
        this.userInfoFacadeService = userInfoFacadeService;
        this.redisSetAdapter = redisSetAdapter;
        this.orderRefundService = orderRefundService;
    }
}

