package com.bxm.fossicker.order.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties("order.config.search")
@Data
/**
 * 订单信息配置类
 * @author Dong_hy
 */
public class OrderInfoProperties {

    /**
     * 淘宝商品服务url
     */
    private String tbCommodityUrl;

    /**
     * 淘宝商品服务app key
     */
    private String tbCommodityAppKey;

    /**
     * 淘宝商品服务app secret
     */
    private String tbCommodityAppSecret;

    /**
     * 渠道邀请码（绑定渠道关系时）
     */
    private String relationInviteCode;

    /**
     * 会员邀请码（绑定会员关系时）
     */
    private String specialInviteCode;

    /**
     * 趣淘金下的万事通appkey (绑定渠道会员关系时)
     */
    private String tbAppkeyWst;

    /**
     * 趣淘金底下的万事通app secret(绑定渠道会员时)
     */
    private String tbAppsecretWst;

    /**
     * 订单每2分钟拉取一次的开关 true-拉取,false-关闭拉取
     */
    private Boolean pullOrderSwitch;

    /**
     * 订单每半天拉取一次的开关 true-拉取,false-关闭拉取
     */
    private Boolean pullOrderDaySwitch;

    /**
     * 常规订单拉取开关  true-拉取   false-关闭
     */
    private Boolean pullOrderSwitchGeneral;

    /**
     * 同步订单状态开关
     */
    private Boolean orderStatusSyncQuartzFlag;

    private Boolean activateCallbackFlag;

    /**
     * 常规订单拉取开关  true-拉取   false-关闭
     */
    private Boolean pullOrderSwitchMember;
}
