package com.bxm.fossicker.order.service.external.impl;

import com.bxm.fossicker.order.common.utils.ApiLimiterFactory;
import com.bxm.fossicker.order.config.OrderInfoProperties;
import com.bxm.fossicker.order.model.dto.TbOrderPageInfo;
import com.bxm.fossicker.order.model.entity.OrderInfoBean;
import com.bxm.fossicker.order.model.enums.OrderTypeEnum;
import com.bxm.fossicker.order.service.external.TbOrderService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.taobao.api.ApiException;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.TaobaoClient;
import com.taobao.api.request.TbkOrderDetailsGetRequest;
import com.taobao.api.response.TbkOrderDetailsGetResponse;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@Service
@Slf4j
public class TbOrderServiceImpl implements TbOrderService {


    @Autowired
    private SequenceCreater sequenceCreater;

    @Autowired
    private OrderInfoProperties orderInfoProperties;

    @Autowired
    private ApiLimiterFactory reteLlimiterFactory;

    @Override
    public TbOrderPageInfo<OrderInfoBean> pullOrderNew(Long pageNo, Long pageSize, String positionIndex,
                                                       Date orderStartTime, Date orderEndTime, int type) {

        TbOrderPageInfo<OrderInfoBean> tbOrderPageInfo = new TbOrderPageInfo<>();
        //令牌限流
        try {
            reteLlimiterFactory.getPermitForOrder(orderInfoProperties.getTbCommodityUrl());
        } catch (InterruptedException e) {
            log.error("订单令牌获取异常：",e);
        }
        TaobaoClient client = new DefaultTaobaoClient(orderInfoProperties.getTbCommodityUrl(),
                orderInfoProperties.getTbCommodityAppKey(), orderInfoProperties.getTbCommodityAppSecret());


        TbkOrderDetailsGetRequest req = new TbkOrderDetailsGetRequest();
        req.setQueryType(1L);
        //下一页必须传入positionIndex
        req.setPositionIndex(positionIndex);
        req.setPageSize(pageSize);
        req.setPageNo(pageNo);
        req.setStartTime(DateUtils.formatDateTime(orderStartTime));
        req.setEndTime(DateUtils.formatDateTime(orderEndTime));
        //tk_status不传表示查询所有状态
        //推广者角色类型-2:二方，3:三方，不传，表示所有角色
        req.setMemberType(2L);
        //渠道订单
        convertSceneType(req, type);

        TbkOrderDetailsGetResponse rsp;
        try {
            rsp = client.execute(req);
        } catch (ApiException e) {
           log.error("拉取订单异常, 拉取时间:{}", orderStartTime, e);
            return null;
        }

        if (null == rsp || !rsp.isSuccess() || CollectionUtils.isEmpty(rsp.getData().getResults())) {
            log.info("从淘宝获取获取订单为空或者失败,查询时间为:{},错误信息:{}", orderStartTime, rsp.getMessage());
            return null;
        }
        List<TbkOrderDetailsGetResponse.PublisherOrderDto> resultRsp = rsp.getData().getResults();
        List<OrderInfoBean> orderInfoList = new ArrayList<>();
        for (TbkOrderDetailsGetResponse.PublisherOrderDto publisherOrderDto : resultRsp) {
            orderInfoList.add(convertOrderInfoNew(publisherOrderDto, type));
        }
       /*List<OrderInfoBean> orderInfoList = rsp.getData().getResults().stream().map(this::convertOrderInfoNew)
                .collect(Collectors.toList());*/

        TbkOrderDetailsGetResponse.OrderPage tbOrderPage = rsp.getData();
        tbOrderPageInfo.setHasNext(tbOrderPage.getHasNext());
        tbOrderPageInfo.setHasPre(tbOrderPage.getHasPre());
        tbOrderPageInfo.setPageNo(tbOrderPage.getPageNo());
        tbOrderPageInfo.setPageSize(tbOrderPage.getPageSize());
        tbOrderPageInfo.setPositionIndex(tbOrderPage.getPositionIndex());
        tbOrderPageInfo.setList(orderInfoList);
        return tbOrderPageInfo;
    }

    /**
     * 转换淘宝订单数据到库中订单数据结果集
     * @param tbOrderInfo 淘宝订单信息
     * @param type 订单类型
     * @return
     */
    private OrderInfoBean convertOrderInfoNew(TbkOrderDetailsGetResponse.PublisherOrderDto tbOrderInfo,int type){
        StringBuilder httpsPre = new StringBuilder("https:");

        OrderInfoBean orderInfo = OrderInfoBean.builder()
                .id(sequenceCreater.nextLongId())
                .goodsId(Objects.toString(tbOrderInfo.getItemId(), null))
                .goodsName(tbOrderInfo.getItemTitle())
                .relationId(Objects.toString(tbOrderInfo.getRelationId(), null))
                .specialId(Objects.toString(tbOrderInfo.getSpecialId(), null))
                .orderSn(Objects.toString(tbOrderInfo.getTradeId(), null))
                .orderParentSn(Objects.toString(tbOrderInfo.getTradeParentId(), null))
                .goodsPrice(StringUtils.isBlank(tbOrderInfo.getItemPrice()) ? null : new BigDecimal(tbOrderInfo.getItemPrice()))
                // 商品购买数量
                .goodsNum(tbOrderInfo.getItemNum())
                //实际支付价格
                .payPrice(StringUtils.isBlank(tbOrderInfo.getAlipayTotalPrice()) ? new BigDecimal("0.00")
                        : new BigDecimal(tbOrderInfo.getAlipayTotalPrice()))
                //时间转换
                .sourceOrderCreateTime(DateUtils.parseDateTime(tbOrderInfo.getTkCreateTime()))
                .sourceOrderEarningTime(DateUtils.parseDateTime(tbOrderInfo.getTkEarningTime()))
                .commission(StringUtils.isBlank(tbOrderInfo.getPubSharePreFee()) ? null : new BigDecimal(tbOrderInfo.getPubSharePreFee()))
                .sourceOwnerOrderStatus(null == tbOrderInfo.getTkStatus() ? null : tbOrderInfo.getTkStatus().intValue())
                .source("TB")
                //新接口提供了商品图片地址
                .imgUrl(httpsPre.append(tbOrderInfo.getItemImg()).toString())
                .pid(parsePid(tbOrderInfo))
                .type(type)
                .tbOrderType(tbOrderInfo.getOrderType())
                .createTime(new Date())
                .build();


        return orderInfo;
    }

    private String parsePid(TbkOrderDetailsGetResponse.PublisherOrderDto tbOrderInfo) {
        StringBuilder pid = new StringBuilder("mm_456760114_")
                .append(tbOrderInfo.getSiteId())
                .append("_")
                .append(tbOrderInfo.getAdzoneId());

        return pid.toString();
    }

    /**
     * 根据定义的类型设置不同的查询参数
     * @param req 淘宝查询参数
     * @param orderType 查询的订单类型
     */
    private void convertSceneType(TbkOrderDetailsGetRequest req, int orderType) {

        //推广者角色类型-为不传-全部角色 --branch/ticket中产品确认更改
        //orderScene 1:常规订单，2:渠道订单，3:会员运营订单，默认为1
        if(OrderTypeEnum.CHANNEL_ORDER.getCode() == orderType){
            //场景订单类型为2渠道订单
            req.setOrderScene(2L);
            return;
        }

        if(OrderTypeEnum.GENERAL_ORDER.getCode() == orderType){
            //场景订单类型为1常规订单
            req.setOrderScene(1L);
            return;
        }

        //默认类型 若上面的都不匹配 默认为渠道订单查询类型
        req.setOrderScene(2L);


    }
}
