package com.bxm.fossicker.order.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.order.common.utils.ApiLimiterFactory;
import com.bxm.fossicker.order.config.OrderInfoProperties;
import com.bxm.fossicker.order.model.param.RelationInfoRspDTO;
import com.bxm.fossicker.order.service.OrderRelationUserService;
import com.bxm.fossicker.user.domain.UserInfoMapper;
import com.bxm.fossicker.user.model.entity.UserInfoBean;
import com.taobao.api.ApiException;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.TaobaoClient;
import com.taobao.api.request.TbkScPublisherInfoSaveRequest;
import com.taobao.api.request.TopAuthTokenCreateRequest;
import com.taobao.api.response.TbkScPublisherInfoSaveResponse;
import com.taobao.api.response.TopAuthTokenCreateResponse;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * @Author: pf.w
 * @Date: 2019/7/23 15:26
 */
@Log4j2
@Service
public class OrderRelationUserServiceImpl implements OrderRelationUserService {

    @Resource
    private UserInfoMapper userInfoMapper;

    @Autowired
    private OrderInfoProperties orderInfoProperties;

    @Autowired
    private ApiLimiterFactory reteLlimiterFactory;

    @Override
    public RelationInfoRspDTO relateUserInfo(Long userId, String code) throws ApiException {
        RelationInfoRspDTO result = new RelationInfoRspDTO();


        TaobaoClient client1 = new DefaultTaobaoClient(orderInfoProperties.getTbCommodityUrl(),
                orderInfoProperties.getTbAppkeyWst(), orderInfoProperties.getTbAppsecretWst());

        // code换token
        String sessionKey = getTbToken(code, client1);

        //绑定会员关系
        TbkScPublisherInfoSaveRequest req1 = new TbkScPublisherInfoSaveRequest();
        // 渠道备案 - 线下场景信息，1 - 门店，2- 学校，3 - 工厂，4 - 其他
        req1.setOfflineScene("4");
        // 渠道备案 - 线上场景信息，1 - 微信群，2- QQ群，3 - 其他
        req1.setOnlineScene("3");
        req1.setInviterCode(orderInfoProperties.getSpecialInviteCode());
        req1.setInfoType(1L);
        req1.setNote("其他");
        TbkScPublisherInfoSaveResponse rsp1 = client1.execute(req1, sessionKey);
        String result1 = rsp1.getBody();
        JSONObject tbResult1 = JSONObject.parseObject(result1);
        JSONObject tbObject1 = JSONObject.parseObject(tbResult1.getString("tbk_sc_publisher_info_save_response"));
        JSONObject tbData1 = JSONObject.parseObject(tbObject1.getString("data"));
        String specialId = tbData1.getString("special_id");

        //绑定渠道关系
        TaobaoClient client3 = new DefaultTaobaoClient(orderInfoProperties.getTbCommodityUrl(),
                orderInfoProperties.getTbAppkeyWst(), orderInfoProperties.getTbAppsecretWst());
        TbkScPublisherInfoSaveRequest req3 = new TbkScPublisherInfoSaveRequest();
        req3.setOfflineScene("4");
        req3.setOnlineScene("3");
        req3.setInviterCode(orderInfoProperties.getRelationInviteCode());
        req3.setInfoType(1L);
        req3.setNote("其他");
        TbkScPublisherInfoSaveResponse rsp3 = client3.execute(req3, sessionKey);
        String result3 = rsp3.getBody();
        JSONObject tbResult3 = JSONObject.parseObject(result3);
        JSONObject tbObject3 = JSONObject.parseObject(tbResult3.getString("tbk_sc_publisher_info_save_response"));
        //为空判断出现错误返回，透传返回值
        if (tbObject3 == null) {

            JSONObject tbOjectError = JSONObject.parseObject(tbResult3.getString("error_response"));
            String errorMsg = tbOjectError.getString("sub_msg");
            result.setOk(false);
            result.setDesc(errorMsg);

            log.warn("绑定失败，错误消息：{},userId:{},code:{}", tbOjectError.toString(), userId, code);

            return result;
        }

        JSONObject tbData3 = JSONObject.parseObject(tbObject3.getString("data"));
        String relationId = tbData3.getString("relation_id");

        RelationInfoRspDTO rd = isBandTB(userId);
        if (rd.isOk()) {
            // 如果已经绑定 则判断是否绑定的relation id就是当前id
            if (Objects.equals(rd.getRelationId(), relationId)) {
                log.warn("绑定成功，但进行了重复绑定, userId: {}, code: {}", userId, code);

                result.setOk(true);
                result.setRelationId(rd.getRelationId());
                result.setDesc("绑定成功");
                return result;
            } else {
                log.warn("绑定失败，重复进行绑定,userId:{},code:{}", userId, code);

                result.setOk(false);
                result.setRelationId(rd.getRelationId());
                result.setDesc("已绑定过，请不要重复绑定；已提供查询是否绑定接口");
                return result;
            }
        }

        if (StringUtils.isBlank(relationId)) {
            log.warn("绑定失败，淘宝API返回relationId为空,userId:{},code:{}", userId, code);

            result.setOk(false);
            result.setDesc("绑定失败");
        } else if (relationIdIsBind(relationId)) {
            log.warn("绑定失败，淘宝账号已绑定其他用户账号,userId:{},code:{}", userId, code);

            result.setOk(false);
            result.setDesc("该淘宝账号已授权其他用户");
        } else {
            userInfoMapper.updateSetTBrelation(userId, relationId, specialId);
            result.setOk(true);
            result.setRelationId(relationId);
            result.setDesc("绑定成功");
        }
        return result;
    }

    /**
     * code换取淘宝token
     */
    private String getTbToken(String code, TaobaoClient client) throws ApiException {
        String sessionKey = "";
        TopAuthTokenCreateRequest req = new TopAuthTokenCreateRequest();
        req.setCode(code);
        TopAuthTokenCreateResponse rsp = client.execute(req);
        if (rsp != null && rsp.isSuccess() && StringUtils.isNotBlank(rsp.getTokenResult())) {
            JSONObject token = JSONObject.parseObject(rsp.getTokenResult());
            if (token.containsKey("access_token")) {
                sessionKey = token.getString("access_token");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("token:[{}]", sessionKey);
        }
        return sessionKey;
    }

    @Override
    public RelationInfoRspDTO isBandTB(Long userId) {
        UserInfoBean userInfo = userInfoMapper.selectByPrimaryKey(userId);
        RelationInfoRspDTO result = new RelationInfoRspDTO();
        if (userInfo == null) {
            result.setOk(false);
            result.setDesc("用户不存在");
            return result;
        }
        if (StringUtils.isNotBlank(userInfo.getTbkRelationId())) {
            result.setOk(true);
            result.setRelationId(userInfo.getTbkRelationId());
            result.setDesc("已绑定");
        } else {
            result.setOk(false);
            result.setDesc("未绑定");
        }
        return result;
    }

    /**
     * 判断该渠道id 是否被绑过
     *
     * @param relationId
     * @return
     */
    private boolean relationIdIsBind(String relationId) {
        UserInfoBean userInfo = userInfoMapper.selectByRelationId(relationId);
        return userInfo != null;
    }
}
