package com.bxm.fossicker.order.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 多麦联盟关于美团的相关配置信息
 * @Author: Gonzo
 * @Date 2020-02-08 11:32
 */
@Data
@Component
@ConfigurationProperties("order.config.duomai.meituan")
public class DuoMaiMeituanProperties {

    /**
     * 多麦的推广链接
     */
    private String trackUrl = "http://c.duomai.com/track.php";

    /**
     * 秘钥
     */
    private String secret = "b8e907609e9ab0fb97f95e96b315d1d4";

    /**
     * 多麦的媒体id
     */
    private String siteId = "267441";

    /**
     * 美团的推广计划id
     */
    private String aid = "4882";


    /**
     * 美团推广的目标地址
     */
    private String targetUrl = "http://fxno-act.meituan.com";

    /**
     * 查询订单列表的每页大小
     * 默认100
     */
    private Integer pageSize = 100;

    /**
     * 返回数据格式
     * 默认json
     */
    private String format = "json";

    /**
     * 每日凌晨同步前多少天的订单
     * 默认3
     */
    private Integer syncCreateOrderBeforeDays = 3;

    /**
     * 订单列表查询接口
     */
    private String orderListQueryUrl = "https://www.duomai.com/api/order.php";

    /**
     * 订单详情明细查询接口
     */
    private String orderDetailUrl = "https://www.duomai.com/api/order.php";

}
