package com.bxm.fossicker.order.service;

import com.bxm.fossicker.order.model.entity.OrderInfoBean;

import java.time.LocalDateTime;

public interface EleTakeOutOrderService {
    /**
     * 同步订单信息
     * @param orderInfo 饿了么订单信息
     * @return 处理是否成功
     */
    boolean syncOrder(OrderInfoBean orderInfo);

    /**
     * 每日一次的订单状态同步
     */
    void syncOrderStatusDays();

    /**
     * 同步指定时间内的饿了么订单状态信息
     * @param orderStartTime 开始时间
     * @param orderEndTime 结束时间
     */
    void syncOrderStatus(LocalDateTime orderStartTime, LocalDateTime orderEndTime);

    /**
     * 根据订单信息 同步状态
     * @param orderInfo 订单信息
     */
    void syncOrderStatus(OrderInfoBean orderInfo);
}
