package com.bxm.fossicker.order.service;

import com.bxm.fossicker.order.model.entity.OrderInfoBean;
import com.bxm.fossicker.order.model.entity.UserOrderExtendInfoBean;
import com.bxm.fossicker.order.model.param.UserOrderParam;
import com.bxm.fossicker.order.model.param.UserOwnOrderWithExtendInfoParam;
import com.bxm.fossicker.order.model.vo.UserOrderInfoVO;

import java.util.List;

/**
 * Created by Gonzo on 2019-07-23.
 */
public interface OrderService {

    /**
     * 获取用户的订单明细
     * @param param
     * @return
     */
    List<UserOrderInfoVO> getUserOrder(UserOrderParam param);

    /**
     * 查询用户的自购订单信息（带拓展信息）
     * @param param param
     * @return 用户的自购订单信息（带拓展信息）
     */
    List<UserOrderExtendInfoBean> selectUserOwnOrderWithExtendInfo(UserOwnOrderWithExtendInfoParam param);

    /**
     * 添加订单信息
     * 以及拓展信息（1.6.0及其之后）
     * @param orderInfoBean 订单信息实体
     * @param commissionType 返佣类型
     * @return 是否添加成功
     */
    Boolean addOrderInfo(OrderInfoBean orderInfoBean, byte commissionType);

    List<OrderInfoBean> getOrderSnList(String relationId);
}
