package com.bxm.fossicker.order.service;

import com.bxm.fossicker.order.model.constant.TakeOutOrderSource;
import com.bxm.fossicker.order.model.entity.OrderInfoTakeOut;

import java.util.Date;

public interface TakeOutOrderCommissionSettleService {

    /**
     * 查询未返佣的外卖订单进行批量佣金结算
     * @param source 外卖订单类型
     * @param timeLimit 截止时间 (查询当前时间之前的未结算)
     */
    void commissionSettleByOrderTypeAndTimeBefore(TakeOutOrderSource source, Date timeLimit);

    /**
     * 订单结算，并返佣
     * @param takeOutOrder 外卖订单
     */
    void commissionSettleByOrder(OrderInfoTakeOut takeOutOrder);
}
