package com.bxm.fossicker.order.service;

import com.bxm.fossicker.order.model.param.TakeOutJumpInfoParam;
import com.bxm.fossicker.order.model.param.TakeOutOrderParam;
import com.bxm.fossicker.order.model.param.UserIdParam;
import com.bxm.fossicker.order.model.vo.EleTaoWord;
import com.bxm.fossicker.order.model.vo.JumpInfo;
import com.bxm.fossicker.order.model.vo.TakeOutOrderInfoVO;
import com.bxm.fossicker.vo.ResponseJson;

import java.util.List;

public interface TakeOutOrderService {

    /**
     * 获取用户外卖订单 分页
     * @param param 分页参数
     * @return 外卖订单
     */
    List<TakeOutOrderInfoVO> getTakeOutList(TakeOutOrderParam param);

    /**
     * 获取美团 or 饿了么的跳转链接
     * @param param param
     * @return 美团 or 饿了么的跳转链接
     */
    ResponseJson<JumpInfo> getJumpInfo(TakeOutJumpInfoParam param);

    /**
     * 获取饿了么淘口令
     * @param param user id 参数
     * @return 饿了么淘口令
     */
    ResponseJson<EleTaoWord> getEleTaoWord(UserIdParam param);
}
