package com.bxm.fossicker.order.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.activity.facade.TaskFacadeService;
import com.bxm.fossicker.activity.facade.enums.ActivityFacadeEnum;
import com.bxm.fossicker.constant.CommonCommodityRedisKey;
import com.bxm.fossicker.constant.UserRedisKeyConstant;
import com.bxm.fossicker.order.common.enums.OrderStatusEnum;
import com.bxm.fossicker.order.common.enums.TbOrderStatusEnum;
import com.bxm.fossicker.order.domain.OrderExtendInfoExtendMapper;
import com.bxm.fossicker.order.domain.OrderInfoMapper;
import com.bxm.fossicker.order.domain.OrderProfitMapper;
import com.bxm.fossicker.order.integration.PushMessageIntegrationService;
import com.bxm.fossicker.order.model.constant.ProfitTypeConstant;
import com.bxm.fossicker.order.model.dto.VipZeroOrderExtendJson;
import com.bxm.fossicker.order.model.entity.OrderExtendInfoBean;
import com.bxm.fossicker.order.model.entity.OrderInfoBean;
import com.bxm.fossicker.order.model.entity.OrderProfitBean;
import com.bxm.fossicker.order.model.enums.ProfitTypeEnum;
import com.bxm.fossicker.order.service.OrderCommissionService;
import com.bxm.fossicker.user.facade.AccountFacadeService;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.fossicker.user.facade.dto.SuperiorDto;
import com.bxm.fossicker.user.facade.enums.UserCashFlowTypeEnum;
import com.bxm.fossicker.user.facade.param.CommissionDraftParam;
import com.bxm.fossicker.user.facade.vip.VipFacadeService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@Service
@Slf4j
public class OrderCommissionServiceImpl implements OrderCommissionService {


    @Resource
    private OrderInfoMapper orderInfoMapper;

    @Resource
    private OrderProfitMapper orderProfitMapper;

    @Resource
    private UserInfoFacadeService userInfoFacadeService;

    @Resource
    private AccountFacadeService accountFacadeService;

    @Resource
    private TaskFacadeService taskFacadeService;

    @Resource
    private PushMessageIntegrationService pushMessageIntegrationService;

    @Resource
    private RedisSetAdapter redisSetAdapter;

    @Resource
    private RedisListAdapter redisListAdapter;

    @Resource
    private VipFacadeService vipFacadeService;

    @Autowired
    private OrderExtendInfoExtendMapper orderExtendInfoExtendMapper;

    @Deprecated
    public Boolean addCommissionV0(String orderId) {
        OrderInfoBean orderInfo = orderInfoMapper.getOrderInfoByOrderId(orderId);
        if (null == orderInfo) {
            log.error("无此订单信息, 查询的订单id为:{}", orderId);
            return false;
        }

        //查用户的关联关系
        SuperiorDto superiorDto;
        String specialId = orderInfo.getSpecialId();
        String relationId = orderInfo.getRelationId();
        //根据会员id查询在自身平台的id以及上层关系。
        SuperiorDto superiorDtoBySpecialId = userInfoFacadeService.getSuperiorBySpecialId(orderInfo.getSpecialId());
        //根据relationId获取平台id以及上层关系
        SuperiorDto superiorDtoByRelationId = userInfoFacadeService.getSuperiorByRelationId(relationId);

        boolean isInvalidOrder = OrderStatusEnum.isInvalidOrder(orderInfo.getOrderStatus());
        //是否分享订单
        boolean isShare = false;
        if (isPurchaseBySelf(superiorDtoBySpecialId, superiorDtoByRelationId)) {
            //===自购单
            superiorDto = superiorDtoBySpecialId;
            if (null == superiorDto.getUserId()) {
                log.info("会员id({})未查询到对应平台的id", specialId);
                return false;
            }
            BigDecimal purchaseCommission = orderInfo.getPurchaseCommission();
            //判断是否vip
            boolean isVip = vipFacadeService.isVip(superiorDto.getUserId());
            if(isVip && Objects.nonNull(orderInfo.getVipPurchaseCommission())){
                purchaseCommission = orderInfo.getVipPurchaseCommission();
            }
            //自购给购买者返利
            addUserAccountByDraftCommission(superiorDto.getUserId(), purchaseCommission,
                    orderId, UserCashFlowTypeEnum.PURCHASED_COMMISSION_REBATE, isInvalidOrder);
            recordOrderProfit(orderInfo, superiorDto.getUserId(), superiorDto.getUserId(),
                    ProfitTypeEnum.PURCHASE, purchaseCommission);

            //给自购人推送佣金到账
            if (!isInvalidOrder) {
                pushMessageIntegrationService.pushPurchase(superiorDto.getUserId(),
                        purchaseCommission,
                        orderInfo.getOrderSn());
            }

            //添加会员多返金额
            if(isVip && !isInvalidOrder && Objects.nonNull(orderInfo.getVipPurchaseCommission())){
                vipFacadeService.addVipCommission(superiorDto.getUserId(),orderInfo.getVipPurchaseCommission()
                        .subtract(orderInfo.getPurchaseCommission()),1);
            }

            Long taskCompleteUserId = superiorDto.getUserId();
            if (null != taskCompleteUserId) {
                //下单记录-用于新人首单
                KeyGenerator redisKey = CommonCommodityRedisKey.COMMODITY_NEWBIE_USER_SET;
                //添加用户购买记录
                redisSetAdapter.add(redisKey, taskCompleteUserId);


                //完成首次下单任务-订单状态为付款成功,且平台用户id不为空
                if (!TbOrderStatusEnum.INVALID.getStatus().equals(orderInfo.getSourceOwnerOrderStatus())) {
                    taskFacadeService.complete(taskCompleteUserId, ActivityFacadeEnum.FIRST_SHOP);
                }
            }
        } else {
            isShare = true;
            //非自购单
            superiorDto = superiorDtoByRelationId;
            if (null == superiorDto || null == superiorDto.getUserId()) {
                log.info("用户relationId({})未查询到对应平台的id", relationId);
                return false;
            }
            //判断是否vip
            BigDecimal purchaseCommission=orderInfo.getPurchaseCommission();
            boolean isVip = vipFacadeService.isVip(superiorDto.getUserId());
            if(isVip && Objects.nonNull(orderInfo.getVipPurchaseCommission())){
                purchaseCommission = orderInfo.getVipPurchaseCommission();
            }
            //分享者分成
            addUserAccountByDraftCommission(superiorDto.getUserId(), purchaseCommission,
                    orderId, UserCashFlowTypeEnum.SHARED_COMMISSION_REBATE, isInvalidOrder);
            recordOrderProfit(orderInfo, superiorDto.getUserId(), superiorDto.getUserId(),
                    ProfitTypeEnum.SHARE, purchaseCommission);

            //分享商品被购买，给分享人推送佣金到账
            if (!isInvalidOrder) {
                pushMessageIntegrationService.pushShare(superiorDto.getUserId(),
                        purchaseCommission,
                        orderInfo.getOrderSn());
            }
            //添加会员多返金额
            if(isVip && !isInvalidOrder && Objects.nonNull(orderInfo.getVipPurchaseCommission())){
                vipFacadeService.addVipCommission(superiorDto.getUserId(),orderInfo.getVipPurchaseCommission()
                        .subtract(orderInfo.getPurchaseCommission()),1);
            }
        }
        //给自购者增加信息
        addOrderToPopwindows(superiorDto.getUserId(),orderInfo.getId().toString());
        //给上级、上上级增加佣金奖励
        if (null != superiorDto.getSuperiorUserId()) {
            //给上级购买者返利并计入订单分成收益表
            addUserAccountByDraftCommission(superiorDto.getSuperiorUserId(), orderInfo.getParentCommission(),
                    orderId, UserCashFlowTypeEnum.COMMUNITY_COMMISSION_REBATE, isInvalidOrder);
            recordOrderProfit(orderInfo, superiorDto.getSuperiorUserId(), superiorDto.getUserId(),
                    ProfitTypeEnum.PARENT, orderInfo.getParentCommission());

            if (!isInvalidOrder) {
                if (isShare) {
                    //给分享订单所属用户的上级用户推送佣金到账
                    pushMessageIntegrationService.pushShareContribute(superiorDto.getSuperiorUserId(),
                            orderInfo.getParentCommission(),
                            orderInfo.getOrderSn());
                } else {
                    //给自购订单所属用户的上级用户推送佣金到账
                    pushMessageIntegrationService.pushPurchaseContribute(superiorDto.getSuperiorUserId(),
                            orderInfo.getParentCommission(),
                            orderInfo.getOrderSn());
                }
            }

            if (null != superiorDto.getTopUserId()) {
                //给顶级购买者返利
                addUserAccountByDraftCommission(superiorDto.getTopUserId(), orderInfo.getGrandparentCommission(),
                        orderId, UserCashFlowTypeEnum.COMMUNITY_COMMISSION_REBATE, isInvalidOrder);
                recordOrderProfit(orderInfo, superiorDto.getTopUserId(), superiorDto.getUserId(),
                        ProfitTypeEnum.GRANDPARENT, orderInfo.getGrandparentCommission());

                if (!isInvalidOrder) {
                    if (isShare) {
                        //给分享订单所属用户的顶级用户推送佣金到账
                        pushMessageIntegrationService.pushShareContribute(superiorDto.getTopUserId(),
                                orderInfo.getGrandparentCommission(),
                                orderInfo.getOrderSn());
                    } else {
                        //给自购订单所属用户的顶级用户推送佣金到账
                        pushMessageIntegrationService.pushPurchaseContribute(superiorDto.getTopUserId(),
                                orderInfo.getGrandparentCommission(),
                                orderInfo.getOrderSn());
                    }
                }
                addOrderToPopwindows(superiorDto.getTopUserId(),orderInfo.getId().toString());
            }
            addOrderToPopwindows(superiorDto.getSuperiorUserId(),orderInfo.getId().toString());

        }

        return true;
    }

    @Override
    public boolean addCommission(String orderSn) {

        OrderInfoBean orderInfo = orderInfoMapper.getOrderInfoByOrderId(orderSn);
        if (Objects.isNull(orderInfo)) {
            log.warn("添加返佣信息失败，无此订单信息, 查询的订单号为:{}", orderSn);
            return false;
        }

        // 根据relationId获取平台id以及上层关系 relation id 对应的用户是最终的受益人 不管是自购还是分享都是如此
        SuperiorDto superiorDtoByRelationId = userInfoFacadeService.getSuperiorByRelationId(orderInfo.getRelationId());
        if (log.isDebugEnabled()) {
            log.debug("订单: {} 获取到的受益人id: {}", orderInfo.getOrderSn(), superiorDtoByRelationId.getUserId());
        }

        // 如果relation id 没有对应的用户 则订单不添加返佣信息
        if (Objects.isNull(superiorDtoByRelationId) || Objects.isNull(superiorDtoByRelationId.getUserId())) {
            log.info("用户relationId({}) 未查询到对应平台的id", orderInfo.getRelationId());
            return false;
        }

        // special 是购买者的信息 通过当前信息对应的userId 判断是否是自购
        SuperiorDto superiorDtoBySpecialId = userInfoFacadeService.getSuperiorBySpecialId(orderInfo.getSpecialId());
        // 是否自购订单
        boolean isPurchaseBySelf = isPurchaseBySelf(superiorDtoBySpecialId, superiorDtoByRelationId);
        // 是否失效订单
        boolean isInvalidOrder = OrderStatusEnum.isInvalidOrder(orderInfo.getOrderStatus());
        Long userId = superiorDtoByRelationId.getUserId();
        // 是否vip
        boolean isVip = vipFacadeService.isVip(userId);

        log.info("添加返佣信息 userId; {} superiorUserId: {} topUserId: {} isPurchaseBySelf: {} isInvalidOrder: {} " +
                        "isVip: {}",
                userId, superiorDtoByRelationId.getSuperiorUserId(), superiorDtoByRelationId.getTopUserId(),
                isPurchaseBySelf, isInvalidOrder, isVip);

        // 自购佣金金额
        BigDecimal commission = isVip ? orderInfo.getVipPurchaseCommission() : orderInfo.getPurchaseCommission();

        // 添加自购佣金等信息
        // 记录profit
        recordOrderProfit(orderInfo, userId, userId,
                // 自购还是分享单
                isPurchaseBySelf ? ProfitTypeEnum.PURCHASE : ProfitTypeEnum.SHARE,
                commission);
        purchaseInfoRecode(superiorDtoBySpecialId.getUserId(), isInvalidOrder, orderInfo, commission, isVip,
                isPurchaseBySelf);

        // 上级返佣
        // 添加profit 信息
        recordOrderProfit(orderInfo, superiorDtoByRelationId.getSuperiorUserId(), superiorDtoByRelationId.getUserId(),
                ProfitTypeEnum.PARENT, orderInfo.getParentCommission());
        superiorInfoRecode(superiorDtoByRelationId.getSuperiorUserId(), orderInfo, isInvalidOrder);

        // 上上级返佣
        // 添加profit 信息
        recordOrderProfit(orderInfo, superiorDtoByRelationId.getTopUserId(), superiorDtoByRelationId.getUserId(),
                ProfitTypeEnum.GRANDPARENT, orderInfo.getGrandparentCommission());
        topInfoRecode(superiorDtoByRelationId.getTopUserId(), orderInfo, isInvalidOrder);

        return true;
    }

    @Override
    public boolean updateVipZeroOrderProfitToSuccess(Long orderId) {

        OrderInfoBean orderInfoBean = orderInfoMapper.getOrderInfoByPrimaryKey(orderId);
        if (Objects.isNull(orderInfoBean)) {
            log.warn("根据订单id: {} 查找不到对应的订单信息", orderId);
            return false;
        }

        // 是否失效订单
        boolean isInvalidOrder = OrderStatusEnum.isInvalidOrder(orderInfoBean.getOrderStatus());
        if (isInvalidOrder) {
            log.warn("订单号: {} 的订单已失效", orderInfoBean.getOrderSn());
            return false;
        }

        // 拓展信息 1.6.0之后才有
        OrderExtendInfoBean extendInfoBean = orderExtendInfoExtendMapper.getByOrderId(orderId);
        if (Objects.isNull(extendInfoBean)) {
            log.warn("根据订单id: {} 查找不到对应的订单拓展信息", orderId);
            return false;
        }

        // 更新订单金额信息
        VipZeroOrderExtendJson json;
        if (StringUtils.isBlank(extendInfoBean.getExtendJson())
                || Objects.isNull(json = JSON.parseObject(extendInfoBean.getExtendJson(), VipZeroOrderExtendJson.class))) {

            log.warn("订单: {} 的vip0元购拓展信息为空 助力失败", orderInfoBean.getOrderSn());
            return false;
        }

        Date now = new Date();
        // 修改订单信息
        // 设置订单金额为之前计算好的
        orderInfoBean.setVipPurchaseCommission(json.getVipPurchaseCommission());
        orderInfoBean.setPurchaseCommission(json.getPurchaseCommission());
        orderInfoBean.setParentCommission(json.getParentCommission());
        orderInfoBean.setGrandparentCommission(json.getGrandparentCommission());
        orderInfoBean.setModifyTime(now);
        // 不更新字段
        orderInfoBean.setCreateTime(null);
        // 更新
        orderInfoMapper.updateByPrimaryKeySelective(orderInfoBean);

        // 修改profit信息
        List<OrderProfitBean> orderProfitBeans = orderProfitMapper.listByOrderId(orderInfoBean.getId());
        OrderProfitBean profitBean = new OrderProfitBean();
        profitBean.setModifyTime(now);
        orderProfitBeans.forEach(p -> {
            profitBean.setId(p.getId());
            switch (p.getType()) {
                // 自购
                case ProfitTypeConstant.PURCHASE:
                    profitBean.setProfitAmount(orderInfoBean.getPurchaseCommission());
                    // 自购的佣金等信息记录
                    purchaseInfoRecode(p.getUserId(), false, orderInfoBean, orderInfoBean.getVipPurchaseCommission(),
                            true, true);
                    break;
                case ProfitTypeConstant.PARENT:
                    profitBean.setProfitAmount(orderInfoBean.getParentCommission());

                    // 上级的佣金信息等记录
                    superiorInfoRecode(p.getUserId(), orderInfoBean, false);
                    break;
                case ProfitTypeConstant.GRANDPARENT:
                    profitBean.setProfitAmount(orderInfoBean.getGrandparentCommission());

                    // 上上级的佣金信息等记录
                    superiorInfoRecode(p.getUserId(), orderInfoBean, false);
                    break;
                default:
                    // 其他情况下的vip 0元购订单是不会生成profit的
                    log.warn("订单号: {} 不是一个有效的vip 0元购订单", orderInfoBean.getOrderSn());
                    return;
            }

            // 更新金额
            orderProfitMapper.updateByPrimaryKeySelective(profitBean);
        });

        return true;
    }

    /**
     * 给上级用户返佣
     * @param superiorUserId 上级信息id
     * @param orderInfo 订单信息
     * @param isInvalidOrder 订单是否失效
     */
    private void superiorInfoRecode(Long superiorUserId, OrderInfoBean orderInfo, boolean isInvalidOrder) {

        // 给上级购买者返利
        if (Objects.nonNull(superiorUserId)) {
            // 计入订单分成收益表
            addUserAccountByDraftCommission(superiorUserId, orderInfo.getParentCommission(),
                    orderInfo.getOrderSn(), UserCashFlowTypeEnum.COMMUNITY_COMMISSION_REBATE, isInvalidOrder);

            // 给订单所属用户的上级用户推送佣金到账
            pushMessageIntegrationService.pushPurchaseContribute(superiorUserId,
                    orderInfo.getParentCommission(),
                    orderInfo.getOrderSn());

            addOrderToPopwindows(superiorUserId, Objects.toString(orderInfo.getId()));
        }
    }

    /**
     * 给顶级添加佣金 推送等
     * @param topUserId 顶级id
     * @param orderInfo 订单信息
     * @param isInvalidOrder 订单是否失效
     */
    private void topInfoRecode(Long topUserId, OrderInfoBean orderInfo, boolean isInvalidOrder) {

        // 给顶级购买者返利
        if (Objects.nonNull(topUserId)) {
            // 计入订单分成收益表
            addUserAccountByDraftCommission(topUserId, orderInfo.getGrandparentCommission(),
                    orderInfo.getOrderSn(), UserCashFlowTypeEnum.COMMUNITY_COMMISSION_REBATE, isInvalidOrder);

            // 给分享订单所属用户的顶级用户推送佣金到账
            pushMessageIntegrationService.pushShareContribute(topUserId,
                    orderInfo.getGrandparentCommission(),
                    orderInfo.getOrderSn());

            addOrderToPopwindows(topUserId, Objects.toString(orderInfo.getId()));
        }

    }

    /**
     * 记录下单信息
     * 下单记录-用于新人首单
     * 完成首次下单任务
     * @param userId userId
     */
    private void addOrderedRecode(Long userId) {
        // 下单记录-用于新人首单
        KeyGenerator redisKey = CommonCommodityRedisKey.COMMODITY_NEWBIE_USER_SET;
        // 添加用户购买记录
        redisSetAdapter.add(redisKey, userId);

        // 完成首次下单任务
        taskFacadeService.complete(userId, ActivityFacadeEnum.FIRST_SHOP);
    }

    /**
     * 自购信息记录
     * 添加profit
     * 推送等
     * @param userId userId
     * @param isInvalidOrder 订单是否失效
     * @param orderInfo orderInfo
     * @param isVip 是否vip
     * @param isPurchaseBySelf 是否自购
     */
    private void purchaseInfoRecode(Long userId, boolean isInvalidOrder, OrderInfoBean orderInfo, BigDecimal commission,
                                    boolean isVip, boolean isPurchaseBySelf) {
        // 添加账户金额
        addUserAccountByDraftCommission(userId, commission,
                orderInfo.getOrderSn(), UserCashFlowTypeEnum.PURCHASED_COMMISSION_REBATE, isInvalidOrder);


        //给自购人推送佣金到账
        if (!isInvalidOrder) {
            pushMessageIntegrationService.pushPurchase(userId, commission, orderInfo.getOrderSn());

            // 添加会员多返金额
            if (isVip && Objects.nonNull(orderInfo.getVipPurchaseCommission())) {
                vipFacadeService.addVipCommission(userId, orderInfo.getVipPurchaseCommission()
                        .subtract(orderInfo.getPurchaseCommission()),1);
            }

            if (isPurchaseBySelf) {
                // 记录下单信息
                addOrderedRecode(userId);
            }
        }

        // 增加弹窗信息
        addOrderToPopwindows(userId, Objects.toString(orderInfo.getId()));
    }


    /**
     * 新增信息到缓存，用于佣金订单跟单成功弹窗展示
     * @param userId 用户id
     * @param orderId 订单号
     */
    public void addOrderToPopwindows(Long userId,String orderId){
        try {
            if(!userId.equals(0)){
                //订单打开页面弹窗信息 1.4版本新增功能
                KeyGenerator keyGenerator = UserRedisKeyConstant.USER_HAS_NEW_FOLLOW_ORDER.copy().setKey(userId.toString());
                redisListAdapter.leftPush(keyGenerator,orderId);
            }
        }catch (Exception e){
            log.error("增加订单打开页面弹窗信息到缓存失败"+e.getMessage());
        }
    }
    /**
     * 添加用户账户佣金拟结算-若订单状态为失效状态则不添加拟结算
     * @param profitUserId         受益者用户ID
     * @param commissionPrice      佣金值
     * @param orderId              订单id
     * @param userCashFlowTypeEnum 类型枚举
     * @param isInvalid            是否失效订单-true为失效
     */
    private void addUserAccountByDraftCommission(Long profitUserId, BigDecimal commissionPrice,
                                                 String orderId, UserCashFlowTypeEnum userCashFlowTypeEnum,
                                                 boolean isInvalid) {
        //若订单状态为失效,则不像账户添加佣金拟结算
        if (isInvalid) {
            return;
        }

        CommissionDraftParam param = new CommissionDraftParam();
        param.setUserId(profitUserId);
        param.setAmount(commissionPrice);
        param.setCashFlowType(userCashFlowTypeEnum);
        param.setRelationId(Long.valueOf(orderId));

        accountFacadeService.commissionDraft(param);
    }

    /**
     * 记录订单收益
     * @param orderInfo       订单信息
     * @param profitUserId    受益人用户id
     * @param userId          订单发起人id
     * @param profitType      订单收益类型
     * @param commissionPrice 实际收益数额
     */
    private void recordOrderProfit(OrderInfoBean orderInfo, Long profitUserId, Long userId,
                                   ProfitTypeEnum profitType, BigDecimal commissionPrice) {

        OrderProfitBean orderProfitEntity = OrderProfitBean.builder()
                .userId(profitUserId)
                .orderId(orderInfo.getId())
                .goodsId(orderInfo.getGoodsId())
                .type(profitType.getCode())
                .orderSn(orderInfo.getOrderSn())
                .profitAmount(commissionPrice)
                .orderStatus(orderInfo.getOrderStatus())
                .orderOwnerUserId(userId.toString())
                .createTime(new Date())
                .build();

        orderProfitMapper.insertSelective(orderProfitEntity);
    }

    /**
     * 判断是否是自购单-两个信息得到的用户id是否是同一个用户
     * @param superiorDtoBySpecialId  根据specialId查询到的用户信息
     * @param superiorDtoByRelationId 根据relationId查询到的用户信息
     * @return true-自购单，false-非自购单
     */
    private boolean isPurchaseBySelf(SuperiorDto superiorDtoBySpecialId, SuperiorDto superiorDtoByRelationId) {
        //会员id,渠道id都不为空且两个id相等 则为自购订单
        return null != superiorDtoBySpecialId && null != superiorDtoByRelationId
                && null != superiorDtoBySpecialId.getUserId()
                && superiorDtoBySpecialId.getUserId().equals(superiorDtoByRelationId.getUserId());
    }

}
