package com.bxm.fossicker.order.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.order.domain.OrderProfitMapper;
import com.bxm.fossicker.order.facade.dto.OrderInfoFacadeDTO;
import com.bxm.fossicker.order.facade.service.OrderFacadeService;
import com.bxm.fossicker.order.model.entity.OrderInfoBean;
import com.bxm.fossicker.order.model.param.OrderProfitParam;
import com.bxm.fossicker.order.model.param.UserOrderParam;
import com.bxm.fossicker.order.service.OrderCommissionService;
import com.bxm.fossicker.order.service.OrderService;
import com.bxm.fossicker.order.service.OrderSyncService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author Gonzo
 * @date 2019-10-10 16:47
 */
@Service
public class OrderFacadeServiceImpl implements OrderFacadeService {

    @Autowired
    private OrderProfitMapper orderProfitMapper;

    @Autowired
    private OrderCommissionService orderCommissionService;

    @Autowired
    private OrderService orderService;

    @Autowired
    private OrderSyncService orderSyncService;

    @Override
    public Boolean hasOrdered(Long userId) {

        UserOrderParam param = new UserOrderParam();
        param.setUserId(userId);
        param.setQueryType(0);

        return orderProfitMapper.selectByUserId(param).stream()
                .filter(p -> Objects.equals(p.getType(), "PURCHASE"))
                .collect(Collectors.toList()).size() > 0;
    }

    @Override
    public String getOrdersInfo(Long userId, List<String> orders) {
        OrderProfitParam orderProfitParam = orderProfitMapper.getOneUserOrdersTotal(userId,orders);
        if(null != orderProfitParam){
            if(orderProfitParam.getNum() > 0 && orderProfitParam.getTotalAmount().compareTo(new BigDecimal("0"))> 0  ){
                return JSONObject.toJSONString(orderProfitParam);
            }
        }
        return null;
    }

    @Override
    public Boolean addCommission(String orderId) {
        return orderCommissionService.addCommission(orderId);
    }

    @Override
    public List<OrderInfoFacadeDTO> getOrderListByRelationId(String relationId) {
        List<OrderInfoBean> orderInfoList = orderService.getOrderSnList(relationId);

        if (CollectionUtils.isEmpty(orderInfoList)) {
            return null;
        }

        return orderInfoList.stream().map(this::convert).collect(Collectors.toList());
    }

    @Override
    public void setSyncOrderStatus(String orderSn, int sourceOwnerOrderStatus) {
        orderSyncService.setSyncOrderStatus(orderSn, sourceOwnerOrderStatus);
    }

    private OrderInfoFacadeDTO convert(OrderInfoBean orderInfoBean) {

        OrderInfoFacadeDTO orderInfoFacadeDTO = new OrderInfoFacadeDTO();
        orderInfoFacadeDTO.setOrderSn(orderInfoBean.getOrderSn());
        orderInfoFacadeDTO.setSourceOwnerOrderStatus(orderInfoBean.getSourceOwnerOrderStatus());

        return orderInfoFacadeDTO;
    }
}
