package com.bxm.fossicker.order.timer;

import com.bxm.fossicker.order.model.constant.TakeOutOrderSource;
import com.bxm.fossicker.order.service.TakeOutOrderCommissionSettleService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.bxm.newidea.component.tools.DateUtils;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Calendar;

/**
 * 美团订单结算
 * @Author: Gonzo
 * @date  2020-03-26 17:42
 * @since 1.6.1
 */
@Slf4j
@Component
public class DuomaiMeituanOrderCommossionSettleMonthTask extends AbstractCronTask<String> {

    @Autowired
    private TakeOutOrderCommissionSettleService takeOutOrderCommissionSettleService;


    @Override
    protected ReturnT<String> service(String s) {
        log.info("执行任务: {} 开始", taskName());
        try {

            Calendar calendar = Calendar.getInstance();
            // 月初
            calendar.set(Calendar.DAY_OF_MONTH, 1);
            // 提前一天 就是上个月月底了
            calendar.add(Calendar.DAY_OF_MONTH, -1);

            // 将三方已结算的订单进行结算
            takeOutOrderCommissionSettleService.commissionSettleByOrderTypeAndTimeBefore(TakeOutOrderSource.MEITUAN,
                    // 上一个月月底的截止时间
                    DateUtils.getDayEndTime(calendar.getTime()));

        } catch(Exception e) {
            log.error("执行任务: {} 失败", taskName(), e);
            return ReturnT.FAIL;
        }

        log.info("执行任务: {} 结束", taskName());
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "美团订单结算返佣";
    }

    @Override
    public String cron() {
        // 每月24 25 26 4点运行
        return "0 0 4 24,25,26 * ? ";
    }
}
