package com.bxm.fossicker.order.timer;


import com.bxm.fossicker.order.service.MeituanTakeOutOrderService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 美团订单信息同步
 * @Author: Gonzo
 * @date  2020-03-26 16:35
 * @since 1.6.1
 */
@Component
@Slf4j
public class DuomaiMeituanOrderSyncDaysTask extends AbstractCronTask<String> {

    @Autowired
    private MeituanTakeOutOrderService meituanTakeOutOrderService;

    @Override
    protected ReturnT<String> service(String s) {
        log.info("执行任务: {} 开始", taskName());
        try {
            meituanTakeOutOrderService.syncOrderOneDayOnce();
        } catch(Exception e) {
            log.error("执行任务: {} 出错", taskName(), e);
            return ReturnT.FAIL;
        }

        log.info("执行任务: {} 结束", taskName());
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "多麦联盟美团订单日拉取";
    }

    @Override
    public String cron() {
        // 每天凌晨20启动
        return "0 20 0 * * ?";
    }
}
