package com.bxm.fossicker.order.timer;

import com.bxm.fossicker.order.model.constant.TakeOutOrderSource;
import com.bxm.fossicker.order.service.EleTakeOutOrderService;
import com.bxm.fossicker.order.service.TakeOutOrderCommissionSettleService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.bxm.newidea.component.tools.DateUtils;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Calendar;

/**
 * 饿了么订单状态同步和佣金结算
 * 每日11点
 * @Author: Gonzo
 * @date  2020-03-26 16:34
 * @since 1.6.1
 */
@Component
@Slf4j
public class EleOrderStatusSyncAndCommissionSettleDaysTask extends AbstractCronTask<String>  {

    @Autowired
    private EleTakeOutOrderService eleTakeOutOrderService;

    @Autowired
    private TakeOutOrderCommissionSettleService takeOutOrderCommossionSettleService;

    @Override
    protected ReturnT<String> service(String s) {
        log.info("执行任务: {} 开始", taskName());
        try {
            // 同步订单状态
            eleTakeOutOrderService.syncOrderStatusDays();

            Calendar calendar = Calendar.getInstance();
            // 提前一天
            calendar.add(Calendar.DAY_OF_MONTH, -1);

            // 将三方已结算的订单进行结算
            takeOutOrderCommossionSettleService.commissionSettleByOrderTypeAndTimeBefore(TakeOutOrderSource.ELE,
                    // 提前一天的截止时间
                    DateUtils.getDayEndTime(calendar.getTime()));
        } catch(Exception e) {
            log.error("执行任务: {} 失败", taskName(), e);
            return ReturnT.FAIL;
        }

        log.info("执行任务: {} 结束", taskName());
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "饿了么订单状态同步和佣金结算";
    }

    @Override
    public String cron() {
        // 每天11点启动
        return "0 0 11 * * ?";
    }
}
