package com.bxm.fossicker.order.timer;

import com.bxm.fossicker.user.facade.UserPayorderInfoFacadeService;
import com.bxm.fossicker.user.facade.enums.UserPayorderInfoStatusEnum;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Author: pf.w
 * @Date: 2019/12/4 15:40
 */
@Component
public class OrderTimeoutTask extends AbstractCronTask<String> {

    @Autowired
    private UserPayorderInfoFacadeService userPayorderInfoFacadeService;

    @Override
    protected ReturnT<String> service(String s) {
        List<String> orders = userPayorderInfoFacadeService.getTimeOutIds();
        if(orders.size() > 0){
            userPayorderInfoFacadeService.updateStatusBatch(orders, UserPayorderInfoStatusEnum.PAY_TIMEOUT.getStatus());
        }
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "支付订单超时更新";
    }

    @Override
    public String cron() {
        return "0/3 * * * * ? ";
    }
}
