package com.bxm.fossicker.order.timer;

import com.bxm.fossicker.order.facade.service.SynchronizeOrderService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * @Author: pf.w
 * @Date: 2019/12/4 15:44
 */
@Component
@Log4j2
public class PayCashTask extends AbstractCronTask<String> {

    @Autowired
    private SynchronizeOrderService synchronizeOrderService;

    @Override
    protected ReturnT<String> service(String s) {
        log.info("----定时返利结算开始   start", LocalDateTime.now());

        try {
            synchronizeOrderService.payCashForLastMonthOrder();
        } catch (Exception e) {
            log.error("定时返利结算,异常为:", e);
            return ReturnT.FAIL;
        }
        log.info("----定时返利结算结束   end", LocalDateTime.now());
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "定时返利结算";
    }

    @Override
    public String cron() {
        //每月24 25 26 号的凌晨3点开始执行
        return "0 0 3 24,25,26 * ? ";
    }
}
