package com.bxm.fossicker.order.timer;

import com.bxm.fossicker.order.common.contants.OrderConstants;
import com.bxm.fossicker.order.facade.service.PullOrderFacadeService;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @Author: pf.w
 * @Date: 2019/12/4 15:47
 */
@Component
@Log4j2
public class PullOrderByDayTask extends AbstractCronTask<String> {
    @Autowired
    private PullOrderFacadeService pullOrderFacadeService;

    @Autowired
    private DistributedLock distributedLock;

    @Autowired
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;

    @Autowired
    private SequenceCreater sequenceCreater;

    @Override
    public ReturnT<String> service(String s) {
        log.info("拉取订单信息-每半天启动一次,时间为:{}", LocalDateTime.now());
        String requestId = sequenceCreater.nextStringId();
        if (!distributedLock.lock(OrderConstants.PULL_ORDER_LOCK, requestId)) {
            try {
                log.info("未获取到定时任务锁,延迟执行:{}", LocalDateTime.now());
                scheduledThreadPoolExecutor.schedule(() -> pullOrderFacadeService.pullOrderByDay(), 20, TimeUnit.SECONDS);
                return ReturnT.SUCCESS;
            } catch(Exception e) {
                log.error("拉取订单信息-每半天启动一次延迟处理业务重试失败", e);
                return ReturnT.FAIL;
            }
        }

        try {
            pullOrderFacadeService.pullOrderByDay();
        } catch (Exception e) {
            log.error("拉取订单信息-每半天启动一次,异常为:", e);
        } finally {
            distributedLock.unlock(OrderConstants.PULL_ORDER_LOCK, requestId);
        }
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "拉取订单信息-每半天启动一次,容错处理";
    }

    @Override
    public String cron() {
        //每半天执行一次,从第三方接口拉取订单信息,容错处理
        return "0 0 0,12 * * ?";
    }
}
