package com.bxm.fossicker.order.timer;

import com.bxm.fossicker.order.common.contants.OrderConstants;
import com.bxm.fossicker.order.facade.service.PullOrderFacadeService;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * @Author: pf.w
 * @Date: 2019/12/4 16:13
 */
@Component
@Log4j2
public class PullOrderTask extends AbstractCronTask<String> {
    @Autowired
    private PullOrderFacadeService pullOrderFacadeService;

    @Autowired
    private DistributedLock distributedLock;

    @Autowired
    private SequenceCreater sequenceCreater;


    @Override
    protected ReturnT<String> service(String s) {
        log.info("拉取订单定时器启动,拉取订单信息,时间为:{}", LocalDateTime.now());
        String requestId = sequenceCreater.nextStringId();
        if (!distributedLock.lock(OrderConstants.PULL_ORDER_LOCK, requestId)) {
            log.error("拉取订单定时器启动,未获取到锁,终止此次定时任务");
            return ReturnT.SUCCESS;
        }

        try {
            log.info("===============拉取渠道订单开始");
            //拉取渠道订单
            pullOrderFacadeService.pullOrder();
            log.info("===============拉取渠道订单结束");

            log.info("===============拉取常规订单开始");
            //拉取完渠道订单再拉取常规订单
            pullOrderFacadeService.pullGeneralOrder();
            log.info("===============拉取常规订单结束");
        } catch (Exception e) {
            log.error("定时拉取订单信息异常,异常为:", e);
        } finally {
            distributedLock.unlock(OrderConstants.PULL_ORDER_LOCK, requestId);
        }
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "拉取订单信息";
    }

    @Override
    public String cron() {
        //每2分钟执行一次,从第三方接口拉取订单信息
        return "0 0/2 * * * ? ";
    }
}
